/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis.generator.executer;

import ins.framework.mybatis.generator.GenConfig;
import ins.framework.mybatis.generator.GenFileInfo;
import ins.framework.mybatis.generator.executer.BaseExecuter;
import ins.framework.mybatis.generator.schema.Column;
import ins.framework.mybatis.generator.schema.Table;
import ins.framework.mybatis.generator.util.GeneratorUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoExecuter
extends BaseExecuter {
    private static final Logger log = LoggerFactory.getLogger(PoExecuter.class);
    private GenFileInfo poInfo;

    public PoExecuter(GenConfig genConfig, GenFileInfo poInfo) {
        super(genConfig);
        this.poInfo = poInfo;
    }

    @Override
    public void build(Table table) throws IOException {
        if (table.getPrimaryKeys().size() == 1) {
            this.buildPo(table);
        } else {
            this.buildUnionKeyPo(table);
            this.buildUnionPo(table);
        }
    }

    private void buildClassHeader(BufferedWriter bw, Table table, List<String> types, String className, String info) throws IOException {
        bw.write(String.format("package %s;", this.poInfo.getPackageName()));
        bw.newLine();
        bw.newLine();
        bw.write("import java.io.Serializable;");
        bw.newLine();
        if (GeneratorUtils.isDate(types)) {
            bw.write("import java.util.Date;");
            bw.newLine();
        }
        if (GeneratorUtils.isDecimal(types)) {
            bw.write("import java.math.BigDecimal;");
            bw.newLine();
        }
        bw.newLine();
        bw.write("import ins.framework.mybatis.annotations.Table;");
        bw.newLine();
        bw.write("import ins.framework.mybatis.annotations.Column;");
        bw.newLine();
        bw.write("import lombok.Data;");
        bw.newLine();
        String classComment = "\u5bf9\u5e94\u8868\u540d\uff1a" + this.getName(table.getName());
        if (table.getComment() != null && table.getComment().trim().length() > 0) {
            classComment = classComment + ",\u5907\u6ce8\uff1a" + table.getComment().trim();
        }
        PoExecuter.buildClassComment(bw, String.format("\u901a\u8fc7ins-framework-mybatis\u5de5\u5177\u81ea\u52a8\u751f\u6210\uff0c\u8bf7\u52ff\u624b\u5de5\u4fee\u6539\u3002\u8868%s\u7684%s<br/>", this.getName(table.getName()), info), classComment);
        bw.newLine();
        bw.write("@Data");
        bw.newLine();
        bw.write(String.format("@Table(name=\"%s\")", this.getName(table.getName())));
        bw.newLine();
        bw.write(String.format("public class %s implements Serializable {", className));
        bw.newLine();
        bw.write("\tprivate static final long serialVersionUID = 1L;");
        bw.newLine();
    }

    private void buildFieldGetterSetter(BufferedWriter bw, Column column) throws IOException {
        String field = PoExecuter.getInstanceName(column.getName());
        bw.write("\t/** \u5bf9\u5e94\u5b57\u6bb5\uff1a" + this.getName(column.getName()));
        String comment = column.getComment();
        if (comment != null && comment.trim().length() > 0) {
            bw.write(",\u5907\u6ce8\uff1a" + comment.trim());
        }
        bw.write(" */");
        bw.newLine();
        bw.write("\t@Column(name=\"" + this.getName(column.getName()) + "\",description=\"" + column.getComment() + "\")");
        bw.newLine();
        bw.write("\tprivate " + PoExecuter.processType(column) + " " + field + ";");
        bw.newLine();
    }

    public void buildPo(Table table) throws IOException {
        List<String> types = GeneratorUtils.getTableColumnTypes(table);
        File beanFile = new File(this.poInfo.getPath(), this.poInfo.getName() + ".java");
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(beanFile)));){
            this.buildClassHeader(bw, table, types, this.poInfo.getName(), "PO\u5bf9\u8c61");
            List<Column> columns = table.getColumns();
            int size = columns.size();
            for (int i = 0; i < size; ++i) {
                Column column = columns.get(i);
                this.buildFieldGetterSetter(bw, column);
            }
            bw.newLine();
            bw.write("}");
            bw.newLine();
            bw.flush();
        }
        log.info("Generate PO file " + beanFile.getAbsolutePath());
    }

    public void buildUnionKeyPo(Table table) throws IOException {
        List<String> types = GeneratorUtils.getTablePrimaryKeysTypes(table);
        String keyPoName = this.poInfo.getName() + "Key";
        File beanFile = new File(this.poInfo.getPath(), keyPoName + ".java");
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(beanFile)));){
            this.buildClassHeader(bw, table, types, keyPoName, "\u590d\u5408\u4e3b\u952ePO\u4e3b\u952e\u5bf9\u8c61");
            List<Column> columns = GeneratorUtils.getTablePrimaryKeysColumns(table);
            int size = columns.size();
            for (int i = 0; i < size; ++i) {
                Column column = columns.get(i);
                this.buildFieldGetterSetter(bw, column);
            }
            bw.newLine();
            bw.write("}");
            bw.newLine();
            bw.flush();
        }
        log.info("Generate PO Key file " + beanFile.getAbsolutePath());
    }

    public void buildUnionPo(Table table) throws IOException {
        List<String> types = GeneratorUtils.getTableColumnTypes(table);
        List<String> primaryKeysCloumnNames = GeneratorUtils.getTablePrimaryKeysCloumnNames(table);
        String keyPoName = this.poInfo.getName() + "Key";
        File beanFile = new File(this.poInfo.getPath(), this.poInfo.getName() + ".java");
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(beanFile)));){
            this.buildClassHeader(bw, table, types, this.poInfo.getName(), "\u590d\u5408\u4e3b\u952ePO\u5bf9\u8c61");
            bw.write("\t/** \u5bf9\u5e94\u590d\u5408\u4e3b\u952e */");
            bw.newLine();
            bw.write("\tprivate " + keyPoName + " " + PoExecuter.getInstanceName(keyPoName) + ";");
            bw.newLine();
            List<Column> columns = table.getColumns();
            int size = columns.size();
            for (int i = 0; i < size; ++i) {
                Column column = columns.get(i);
                if (primaryKeysCloumnNames.contains(column.getName().toLowerCase())) continue;
                this.buildFieldGetterSetter(bw, column);
            }
            bw.newLine();
            bw.write("}");
            bw.newLine();
            bw.flush();
        }
        log.info("Generate PO file " + beanFile.getAbsolutePath());
    }
}

