/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis.generator.executer;

import ins.framework.mybatis.generator.GenConfig;
import ins.framework.mybatis.generator.GenFileInfo;
import ins.framework.mybatis.generator.executer.BaseExecuter;
import ins.framework.mybatis.generator.schema.Column;
import ins.framework.mybatis.generator.schema.Table;
import ins.framework.mybatis.generator.util.GeneratorUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoExecuter
extends BaseExecuter {
    private static final Logger log = LoggerFactory.getLogger(VoExecuter.class);
    private GenFileInfo voInfo;

    public VoExecuter(GenConfig genConfig, GenFileInfo voInfo) {
        super(genConfig);
        this.voInfo = voInfo;
    }

    @Override
    public void build(Table table) throws IOException {
        if (table.getPrimaryKeys().size() == 1) {
            this.buildVo(table);
        } else {
            this.buildUnionKeyVo(table);
            this.buildUnionVo(table);
        }
    }

    private void buildClassHeader(BufferedWriter bw, Table table, List<String> types, String className, String info) throws IOException {
        bw.write("package " + this.voInfo.getPackageName() + ";");
        bw.newLine();
        bw.newLine();
        bw.write("import java.io.Serializable;");
        bw.newLine();
        if (GeneratorUtils.isDate(types)) {
            bw.write("import java.util.Date;");
            bw.newLine();
        }
        if (GeneratorUtils.isDecimal(types)) {
            bw.write("import java.math.BigDecimal;");
            bw.newLine();
        }
        bw.newLine();
        bw.write("import lombok.Data;");
        bw.newLine();
        String classComment = "\u5bf9\u5e94\u8868\u540d\uff1a" + this.getName(table.getName());
        if (table.getComment() != null && table.getComment().trim().length() > 0) {
            classComment = classComment + ",\u5907\u6ce8\uff1a" + table.getComment().trim();
        }
        VoExecuter.buildClassComment(bw, String.format("\u901a\u8fc7ins-framework-mybatis\u5de5\u5177\u81ea\u52a8\u751f\u6210\uff0c\u8868%s\u7684%s<br/>", this.getName(table.getName()), info), classComment);
        bw.newLine();
        bw.write("@Data");
        bw.newLine();
        bw.write("public class " + className + " implements Serializable {");
        bw.newLine();
        bw.write("\tprivate static final long serialVersionUID = 1L;");
        bw.newLine();
    }

    private void buildFieldGetterSetter(BufferedWriter bw, Column column) throws IOException {
        String field = VoExecuter.getInstanceName(column.getName());
        bw.write("\t/** \u5bf9\u5e94\u5b57\u6bb5\uff1a" + this.getName(column.getName()));
        String comment = column.getComment();
        if (comment != null && comment.trim().length() > 0) {
            bw.write(",\u5907\u6ce8\uff1a" + comment.trim());
        }
        bw.write(" */");
        bw.newLine();
        bw.write("\tprivate " + VoExecuter.processType(column) + " " + field + ";");
        bw.newLine();
    }

    public void buildVo(Table table) throws IOException {
        List<String> types = GeneratorUtils.getTableColumnTypes(table);
        File beanFile = new File(this.voInfo.getPath(), this.voInfo.getName() + ".java");
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(beanFile)));){
            this.buildClassHeader(bw, table, types, this.voInfo.getName(), "VO\u5bf9\u8c61");
            List<Column> columns = table.getColumns();
            int size = columns.size();
            for (int i = 0; i < size; ++i) {
                Column column = columns.get(i);
                this.buildFieldGetterSetter(bw, column);
            }
            bw.newLine();
            bw.write("}");
            bw.newLine();
            bw.flush();
        }
        log.info("Generate VO file " + beanFile.getAbsolutePath());
    }

    public void buildUnionKeyVo(Table table) throws IOException {
        List<String> types = GeneratorUtils.getTablePrimaryKeysTypes(table);
        String keyVoName = this.voInfo.getName().substring(0, this.voInfo.getName().length() - 2) + "KeyVo";
        File beanFile = new File(this.voInfo.getPath(), keyVoName + ".java");
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(beanFile)));){
            this.buildClassHeader(bw, table, types, keyVoName, "\u590d\u5408\u4e3b\u952eVO\u4e3b\u952e\u5bf9\u8c61");
            List<Column> columns = GeneratorUtils.getTablePrimaryKeysColumns(table);
            int size = columns.size();
            for (int i = 0; i < size; ++i) {
                Column column = columns.get(i);
                this.buildFieldGetterSetter(bw, column);
            }
            bw.newLine();
            bw.write("}");
            bw.newLine();
            bw.flush();
        }
        log.info("Generate VO Key file " + beanFile.getAbsolutePath());
    }

    public void buildUnionVo(Table table) throws IOException {
        List<String> types = GeneratorUtils.getTableColumnTypes(table);
        String keyVoName = this.voInfo.getName().substring(0, this.voInfo.getName().length() - 2) + "KeyVo";
        List<String> primaryKeysCloumnNames = GeneratorUtils.getTablePrimaryKeysCloumnNames(table);
        File beanFile = new File(this.voInfo.getPath(), this.voInfo.getName() + ".java");
        try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(beanFile)));){
            this.buildClassHeader(bw, table, types, this.voInfo.getName(), "\u590d\u5408\u4e3b\u952eVO\u5bf9\u8c61");
            bw.write("\t/** \u5bf9\u5e94\u590d\u5408\u4e3b\u952e */");
            bw.newLine();
            bw.write("\tprivate " + keyVoName + " " + VoExecuter.getInstanceName(keyVoName) + ";");
            bw.newLine();
            List<Column> columns = table.getColumns();
            int size = columns.size();
            for (int i = 0; i < size; ++i) {
                Column column = columns.get(i);
                if (primaryKeysCloumnNames.contains(column.getName().toLowerCase())) continue;
                this.buildFieldGetterSetter(bw, column);
            }
            bw.newLine();
            bw.write("}");
            bw.newLine();
            bw.flush();
        }
        log.info("Generate VO file " + beanFile.getAbsolutePath());
    }
}

