/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis.generator.util;

import ins.framework.mybatis.generator.schema.Column;
import ins.framework.mybatis.generator.schema.PrimaryKey;
import ins.framework.mybatis.generator.schema.Table;
import ins.framework.mybatis.generator.util.WordFileUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GeneratorUtils {
    public static List<String> getTableColumnTypes(Table table) {
        ArrayList<String> types = new ArrayList<String>();
        List<Column> columns = table.getColumns();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            Column column = columns.get(i);
            types.add(column.getType());
        }
        return types;
    }

    public static List<Column> getTablePrimaryKeysColumns(Table table) {
        HashMap<String, Column> columnMap = new HashMap<String, Column>();
        List<Column> columns = table.getColumns();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            Column column = columns.get(i);
            columnMap.put(column.getName().toLowerCase(), column);
        }
        ArrayList<Column> result = new ArrayList<Column>();
        List<PrimaryKey> primaryKeys = table.getPrimaryKeys();
        size = primaryKeys.size();
        for (int i = 0; i < size; ++i) {
            PrimaryKey primaryKey = primaryKeys.get(i);
            result.add((Column)columnMap.get(primaryKey.getColumnName().toLowerCase()));
        }
        return result;
    }

    public static List<String> getTablePrimaryKeysCloumnNames(Table table) {
        ArrayList<String> result = new ArrayList<String>();
        List<PrimaryKey> primaryKeys = table.getPrimaryKeys();
        int size = primaryKeys.size();
        for (int i = 0; i < size; ++i) {
            PrimaryKey primaryKey = primaryKeys.get(i);
            result.add(primaryKey.getColumnName().toLowerCase());
        }
        return result;
    }

    public static List<String> getTablePrimaryKeysTypes(Table table) {
        HashMap<String, String> columnMap = new HashMap<String, String>();
        List<Column> columns = table.getColumns();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            Column column = columns.get(i);
            columnMap.put(column.getName().toLowerCase(), column.getType());
        }
        ArrayList<String> types = new ArrayList<String>();
        List<PrimaryKey> primaryKeys = table.getPrimaryKeys();
        size = primaryKeys.size();
        for (int i = 0; i < size; ++i) {
            PrimaryKey primaryKey = primaryKeys.get(i);
            types.add((String)columnMap.get(primaryKey.getColumnName().toLowerCase()));
        }
        return types;
    }

    public static boolean isDate(List<String> types) {
        for (String type : types) {
            String t = type.toLowerCase();
            if (!t.contains("date") && !t.contains("time")) continue;
            return true;
        }
        return false;
    }

    public static boolean isDecimal(List<String> types) {
        for (String type : types) {
            if (!type.toLowerCase().contains("number") && !type.toLowerCase().contains("numeric") && !type.toLowerCase().contains("decimal")) continue;
            return true;
        }
        return false;
    }

    public static String getInstanceName(String field) {
        return WordFileUtils.getBeautyInstanceName(field);
    }

    public static String getObjectName(String field) {
        return WordFileUtils.getBeautyObjectName(field);
    }
}

