/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis.generator.util;

import ins.framework.mybatis.generator.util.Word;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.PropertyResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordFileUtils {
    private static final Logger log = LoggerFactory.getLogger(WordFileUtils.class);
    public static final String WORD_ROOT_FILE = "wordroot.properties";
    public static final String WORD_ROOT_TABLE_FILE = "wordroot-table.properties";
    private static Map<String, Word> wordMap = new HashMap<String, Word>();
    public static boolean hasShowHelp = false;

    private WordFileUtils() {
    }

    public static synchronized void initWordMap() {
        if (!hasShowHelp) {
            log.info("**************************************************************");
            log.info("**\u5f00\u59cb\u52a0\u8f7d\u8bcd\u6839\u8868\uff0c\u8bcd\u6839\u4f18\u5148\u7ea7\u5982\u4e0b\uff1a ");
            log.info("**1\uff1a\u4ee5\u4e0b\u5212\u7ebf\u5206\u9694\u7684\u547d\u540d");
            log.info("**2\uff1a\u81ea\u5e26\u6807\u51c6\u8bcd\u6839\u8868(wordroot.properties)");
            log.info("**3\uff1a\u81ea\u5e26\u6807\u51c6\u8bcd\u6839\u8868\u4e1a\u52a1\u8868(wordroot-table.properties)");
            log.info("**4\uff1a\u81ea\u5b9a\u4e49\u8bcd\u6839\u8868\u6587\u4ef6(wordfile9.properties->wordfile9.properties)");
            log.info("**5\uff1a\u6570\u636e\u5e93\u4e2d\u7684\u5927\u5c0f\u5199");
            log.info("**6\uff1a\u5168\u90e8\u6539\u6210\u5c0f\u5199");
            log.info("**************************************************************");
            hasShowHelp = true;
        }
        try {
            for (int i = 9; i >= 1; --i) {
                WordFileUtils.init("wordfile" + i + ".properties");
            }
            WordFileUtils.init(WORD_ROOT_TABLE_FILE);
            WordFileUtils.init(WORD_ROOT_FILE);
        }
        catch (IOException e) {
            log.warn("{}", (Throwable)e);
        }
    }

    private static String getClassNameWithoutPackage(Class<?> cl) {
        String className = cl.getName();
        int pos = className.lastIndexOf(46) + 1;
        if (pos == -1) {
            pos = 0;
        }
        return className.substring(pos);
    }

    public static String getRealPathName(Class<?> cl) {
        URL url = cl.getResource(WordFileUtils.getClassNameWithoutPackage(cl) + ".class");
        if (url != null) {
            return url.getPath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init(String fileName) throws IOException {
        InputStream is = WordFileUtils.class.getClassLoader().getResourceAsStream(fileName);
        if (is != null) {
            try {
                log.info("Load wordfile " + fileName);
                PropertyResourceBundle bundle = new PropertyResourceBundle(is);
                Enumeration<String> ration = bundle.getKeys();
                while (ration.hasMoreElements()) {
                    String objKey = ration.nextElement();
                    if (objKey == null) continue;
                    String name = objKey;
                    String key = name.toLowerCase();
                    String value = bundle.getString(name);
                    if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                    value = new String(value.getBytes("UTF-8"));
                    Word word = new Word(name, value);
                    wordMap.put(key, word);
                }
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
    }

    public static String getBeautyObjectName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name must have value.");
        }
        String key = name.toLowerCase();
        key = key.replace("_", "");
        String beautyName = null;
        if (name.contains("_")) {
            StringBuilder sb = new StringBuilder();
            String[] fields = name.split("_");
            sb.append(fields[0].toLowerCase());
            for (int i = 1; i < fields.length; ++i) {
                String temp = fields[i];
                sb.append(temp.substring(0, 1).toUpperCase());
                sb.append(temp.substring(1).toLowerCase());
            }
            beautyName = sb.toString();
        } else if (wordMap.containsKey(key)) {
            beautyName = wordMap.get(key).getName();
            beautyName = WordFileUtils.upperCaseFirstChar(beautyName);
        } else {
            beautyName = !name.toLowerCase().equals(name) && !name.toUpperCase().equals(name) ? name : name.toLowerCase();
        }
        beautyName = WordFileUtils.upperCaseFirstChar(beautyName);
        return beautyName;
    }

    public static String getBeautyInstanceName(String name) {
        String beautyName = WordFileUtils.getBeautyObjectName(name);
        if (beautyName.length() <= 1 || !Character.isUpperCase(beautyName.charAt(1))) {
            beautyName = WordFileUtils.lowerCaseFirstChar(beautyName);
        }
        return beautyName;
    }

    public static String getBeautyDesc(String name) {
        String beautyDesc = "";
        String key = name.toLowerCase();
        beautyDesc = wordMap.containsKey(key = key.replace("_", "")) ? wordMap.get(key).getDesc() : name;
        return beautyDesc;
    }

    public static String lowerCaseFirstChar(String iString) {
        String newString = iString.substring(0, 1).toLowerCase() + iString.substring(1);
        return newString;
    }

    public static String upperCaseFirstChar(String iString) {
        String newString = iString.substring(0, 1).toUpperCase() + iString.substring(1);
        return newString;
    }

    public static void printString(String value) {
        try {
            int i;
            String[] codes = new String[]{"GBK", "ISO8859-1", "UTF-8"};
            for (i = 0; i < codes.length; ++i) {
                for (int j = 0; j < codes.length; ++j) {
                    if (i == j) continue;
                    log.info(codes[i] + "--" + codes[j] + "====" + new String(value.getBytes(codes[i]), codes[j]));
                }
            }
            for (i = 0; i < codes.length; ++i) {
                log.info(codes[i] + "====" + new String(value.getBytes(codes[i])));
            }
            for (i = 0; i < codes.length; ++i) {
                log.info(codes[i] + "==----==" + new String(value.getBytes(), codes[i]));
            }
        }
        catch (Exception e) {
            log.warn("{}", (Throwable)e);
        }
    }
}

