/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis.generator;

import ins.framework.mybatis.generator.DatabaseUtils;
import ins.framework.mybatis.generator.GenConfig;
import ins.framework.mybatis.generator.GenParam;
import ins.framework.mybatis.generator.GenType;
import ins.framework.mybatis.generator.schema.Database;
import ins.framework.mybatis.generator.schema.Table;
import ins.framework.mybatis.generator.util.WordFileUtils;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseGenerator {
    private static final Logger log = LoggerFactory.getLogger(BaseGenerator.class);
    protected static final String JAVA_SUFFIX = ".java";
    protected static final String XML_SUFFIX = ".xml";
    protected GenConfig genConfig;
    protected List<GenParam> paramList;
    protected Database database;
    protected boolean fileOvervide;

    BaseGenerator() {
    }

    protected abstract void run(Table var1, String var2) throws IOException;

    protected abstract void runCommon() throws IOException;

    public void setGenConfig(GenConfig genConfig) {
        this.genConfig = genConfig;
    }

    public void setParamList(List<GenParam> paramList) {
        this.paramList = paramList;
    }

    protected static String getPathFromPackageName(String packageName) {
        if (StringUtils.isEmpty((CharSequence)packageName)) {
            return "";
        }
        return packageName.replace(".", File.separator);
    }

    protected static String getFilePath(String savePath, String segment) {
        File folder = new File(savePath, segment);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return folder.getPath();
    }

    protected boolean containsGenType(GenType genType) {
        for (GenType gen : this.genConfig.getGenTypes()) {
            if (gen != genType) continue;
            return true;
        }
        return false;
    }

    public void generate() {
        WordFileUtils.initWordMap();
        if (StringUtils.isBlank((CharSequence)this.genConfig.getInsertTimeForHisName())) {
            this.genConfig.setInsertTimeForHisName("insertTimeForHis");
        }
        this.genConfig.setInsertTimeForHisName(this.genConfig.getInsertTimeForHisName().toLowerCase(Locale.getDefault()).replace("_", ""));
        if (StringUtils.isBlank((CharSequence)this.genConfig.getOperateTimeForHisName())) {
            this.genConfig.setOperateTimeForHisName("operateTimeForHis");
        }
        this.genConfig.setOperateTimeForHisName(this.genConfig.getOperateTimeForHisName().toLowerCase(Locale.getDefault()).replace("_", ""));
        if (StringUtils.isBlank((CharSequence)this.genConfig.getVersionName())) {
            this.genConfig.setVersionName("Version");
        }
        this.genConfig.setVersionName(this.genConfig.getVersionName().toLowerCase(Locale.getDefault()).replace("_", ""));
        if (StringUtils.isBlank((CharSequence)this.genConfig.getSaveDirForVo())) {
            this.genConfig.setSaveDirForVo(this.genConfig.getSaveDir());
        }
        if (StringUtils.isBlank((CharSequence)this.genConfig.getSaveDirForXml())) {
            this.genConfig.setSaveDirForXml(new File(new File(this.genConfig.getSaveDir()), "../resources/mapper").getAbsolutePath());
            new File(this.genConfig.getSaveDirForXml(), "base").mkdirs();
            new File(this.genConfig.getSaveDirForXml(), "custom").mkdirs();
        }
        if ((this.containsGenType(GenType.VO) || this.containsGenType(GenType.DTO)) && StringUtils.isBlank((CharSequence)this.genConfig.getSaveDirForVo())) {
            this.genConfig.setSaveDirForVo(this.genConfig.getSaveDir());
            log.info("\u672a\u8bbe\u7f6eSaveDirForVo\u53c2\u6570,\u4f7f\u7528\u9ed8\u8ba4\u4f4d\u7f6e");
        }
        if (this.containsGenType(GenType.MAPPER_XML) && StringUtils.isBlank((CharSequence)this.genConfig.getSaveDirForXml())) {
            throw new IllegalArgumentException("\u751f\u6210Mapper XML\u65f6\u9700\u8981\u8bbe\u7f6eSaveDirForXml\u53c2\u6570");
        }
        if (this.containsGenType(GenType.BASE_MAPPER_XML) && StringUtils.isBlank((CharSequence)this.genConfig.getSaveDirForXml())) {
            throw new IllegalArgumentException("\u751f\u6210Base Mapper XML\u65f6\u9700\u8981\u8bbe\u7f6eSaveDirForXml\u53c2\u6570");
        }
        try {
            Properties props = new Properties();
            props.setProperty("user", this.genConfig.getDbUser());
            props.setProperty("password", this.genConfig.getDbPassword());
            props.setProperty("remarks", "true");
            props.setProperty("useInformationSchema", "true");
            try (Connection conn = DriverManager.getConnection(this.genConfig.getDbUrl(), props);){
                Map<String, String> tableNamesMap;
                DatabaseUtils databaseUtils = DatabaseUtils.getInstance(conn, this.genConfig.getDbCatalog(), this.genConfig.getDbSchema());
                this.database = databaseUtils.getDatabase();
                String dbName = this.database.getProductName().toLowerCase(Locale.getDefault());
                if (StringUtils.isBlank((CharSequence)this.genConfig.getDbSchema()) && dbName.indexOf("oracle") != -1) {
                    this.genConfig.setDbSchema(this.genConfig.getDbUser().toUpperCase(Locale.getDefault()));
                }
                if ((tableNamesMap = databaseUtils.getAllTableNamesMap()).size() == 0) {
                    return;
                }
                for (GenParam genParam : this.paramList) {
                    String[] tableNames = genParam.getTables();
                    for (int i = 0; i < tableNames.length; ++i) {
                        String tableName = tableNames[i].toLowerCase(Locale.getDefault());
                        if (!tableNamesMap.containsKey(tableName)) {
                            log.warn("Can't find table or view {}", (Object)tableName);
                            continue;
                        }
                        Table table = databaseUtils.getTableInfo(tableNamesMap.get(tableName));
                        this.run(table, genParam.getModule());
                    }
                }
                this.runCommon();
            }
        }
        catch (Exception e) {
            log.warn("{}", (Throwable)e);
        }
    }

    protected boolean validFile(String dirPath, String beanName, String suffix) {
        File file = new File(dirPath, beanName + suffix);
        return !file.exists() || this.fileOvervide;
    }

    protected void openDir() {
        try {
            String osName = System.getProperty("os.name");
            if (osName != null) {
                if (osName.contains("Mac")) {
                    Runtime.getRuntime().exec("open " + this.genConfig.getSaveDir());
                } else if (osName.contains("Windows")) {
                    Runtime.getRuntime().exec("cmd /c start " + this.genConfig.getSaveDir());
                } else {
                    log.error("save dir:" + this.genConfig.getSaveDir());
                }
            }
        }
        catch (IOException e) {
            log.warn("{}", (Throwable)e);
        }
    }
}

