/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis.generator;

import ins.framework.mybatis.generator.schema.Column;
import ins.framework.mybatis.generator.schema.Database;
import ins.framework.mybatis.generator.schema.PrimaryKey;
import ins.framework.mybatis.generator.schema.Table;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DatabaseUtils {
    private static final Logger log = LoggerFactory.getLogger(DatabaseUtils.class);
    private Connection conn;
    private String catalog;
    private String schema;
    private Database database;

    private DatabaseUtils() {
    }

    public Database getDatabase() {
        return this.database;
    }

    public static DatabaseUtils getInstance(Connection conn, String catalog, String schema) {
        DatabaseUtils obj = new DatabaseUtils();
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            Database database = new Database();
            database.setProductName(metaData.getDatabaseProductName());
            database.setProductVersion(metaData.getDatabaseProductVersion());
            obj.conn = conn;
            obj.database = database;
            obj.catalog = catalog;
            obj.schema = schema;
        }
        catch (SQLException e) {
            log.warn("{}", (Throwable)e);
        }
        return obj;
    }

    public Map<String, String> getAllTableNamesMap() {
        ResultSet rs = null;
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            DatabaseMetaData metaData = this.conn.getMetaData();
            rs = metaData.getTables(this.catalog, this.schema, null, new String[]{"TABLE", "VIEW"});
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                result.put(tableName.toLowerCase(Locale.getDefault()), tableName);
            }
            rs.close();
        }
        catch (SQLException e) {
            log.warn("{}", (Throwable)e);
        }
        return result;
    }

    public Table getTableInfo(String tableName) {
        Table table = new Table();
        table.setName(tableName);
        ResultSet rs = null;
        try {
            DatabaseMetaData metaData = this.conn.getMetaData();
            rs = metaData.getTables(this.catalog, this.schema, tableName, new String[]{"TABLE", "VIEW"});
            if (rs.next()) {
                table.setComment(rs.getString("REMARKS"));
            }
            rs.close();
        }
        catch (SQLException e) {
            log.warn("{}", (Throwable)e);
        }
        if (table.getComment() == null) {
            table.setComment("");
        }
        table.setColumns(this.getTableColumns(tableName));
        table.setPrimaryKeys(this.getTablePrimaryKeys(tableName));
        return table;
    }

    private List<Column> getTableColumns(String tableName) {
        ArrayList<Column> columns = new ArrayList<Column>();
        HashMap<String, String> map = new HashMap<String, String>();
        ResultSet rs = null;
        try {
            DatabaseMetaData metaData = this.conn.getMetaData();
            rs = metaData.getColumns(this.catalog, this.schema, tableName, "%");
            while (rs.next()) {
                Column column = new Column();
                column.setName(rs.getString("COLUMN_NAME"));
                column.setType(rs.getString("TYPE_NAME"));
                column.setSize(rs.getInt("COLUMN_SIZE"));
                column.setComment(rs.getString("REMARKS"));
                column.setNullable(rs.getBoolean("NULLABLE"));
                column.setDefaultValue(rs.getString("COLUMN_DEF"));
                if (column.getType().toLowerCase(Locale.US).contains("serial")) {
                    column.setAutoIncrement(true);
                } else {
                    column.setAutoIncrement(this.isAutoIncrement(rs));
                }
                if (column.getComment() == null) {
                    column.setComment("");
                }
                if (map.containsKey(column.getName())) {
                    throw new IllegalArgumentException("\u53d1\u73b0\u91cd\u590d\u5b57\u6bb5\uff0c\u5fc5\u987b\u8bbe\u7f6edbcatalog\u53c2\u6570");
                }
                map.put(column.getName(), "");
                columns.add(column);
            }
            rs.close();
        }
        catch (SQLException e) {
            log.warn("{}", (Throwable)e);
        }
        return columns;
    }

    private boolean isAutoIncrement(ResultSet rs) {
        boolean result = false;
        try {
            String mysqlResult = rs.getString("IS_AUTOINCREMENT");
            result = "YES".equals(mysqlResult) ? true : ("NO".equals(mysqlResult) ? false : rs.getBoolean("IS_AUTOINCREMENT"));
        }
        catch (NumberFormatException | SQLException e) {
            if (!e.getMessage().contains("No such column name") && !e.getMessage().contains("\u5217\u540d\u65e0\u6548")) {
                log.warn("{}", (Object)e.getMessage(), (Object)e);
            }
            result = false;
        }
        return result;
    }

    private List<PrimaryKey> getTablePrimaryKeys(String tableName) {
        ArrayList<PrimaryKey> primaryKeys = new ArrayList<PrimaryKey>();
        ResultSet rs = null;
        try {
            DatabaseMetaData metaData = this.conn.getMetaData();
            rs = metaData.getPrimaryKeys(this.catalog, this.schema, tableName);
            while (rs.next()) {
                PrimaryKey obj = new PrimaryKey();
                obj.setColumnName(rs.getString("COLUMN_NAME"));
                obj.setKeySeq(rs.getInt("KEY_SEQ"));
                obj.setPkName(rs.getString("PK_NAME"));
                primaryKeys.add(obj);
            }
            rs.close();
        }
        catch (SQLException e) {
            log.warn("{}", (Throwable)e);
        }
        return primaryKeys;
    }
}

