/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis.generator;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.TemplateExceptionHandler;
import ins.framework.mybatis.generator.BaseGenerator;
import ins.framework.mybatis.generator.CodeStyle;
import ins.framework.mybatis.generator.GenFileInfo;
import ins.framework.mybatis.generator.GenType;
import ins.framework.mybatis.generator.executer.DaoExecuter;
import ins.framework.mybatis.generator.executer.MyBatisBaseCommonXmlExecuter;
import ins.framework.mybatis.generator.executer.MyBatisBaseXmlExecuter;
import ins.framework.mybatis.generator.executer.MyBatisCustomCommonXmlExecuter;
import ins.framework.mybatis.generator.executer.MyBatisCustomXmlExecuter;
import ins.framework.mybatis.generator.executer.PoExecuter;
import ins.framework.mybatis.generator.executer.VoExecuter;
import ins.framework.mybatis.generator.schema.Column;
import ins.framework.mybatis.generator.schema.PrimaryKey;
import ins.framework.mybatis.generator.schema.Table;
import ins.framework.mybatis.generator.util.GeneratorUtils;
import java.io.IOException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Generator
extends BaseGenerator {
    private static final Logger log = LoggerFactory.getLogger(Generator.class);
    private GenFileInfo voInfo;
    private GenFileInfo poInfo;
    private GenFileInfo daoInfo;
    private GenFileInfo baseMapperXmlInfo;
    private GenFileInfo mapperXmlInfo;

    private String assemblePackage(String layer, String ... parts) {
        StringBuilder buf = new StringBuilder(this.genConfig.getBasePackage());
        buf.append('.').append(layer);
        for (String part : parts) {
            buf.append('.').append(part);
        }
        return buf.toString();
    }

    private static String assembleXmlPackage(String module) {
        String result = "";
        result = module != null && module.trim().length() > 0 ? module : "misc";
        return result;
    }

    private void resetFileInfo(String keyNameIn, String module) {
        String path;
        String packageName;
        String name;
        String saveDir = this.genConfig.getSaveDir();
        String keyName = keyNameIn;
        if (this.genConfig.getIgnoreTablePrefixs() != null) {
            for (String ignoreTablePrefix : this.genConfig.getIgnoreTablePrefixs()) {
                ignoreTablePrefix = ignoreTablePrefix.replace("_", "");
                if (!keyName.toLowerCase(Locale.getDefault()).startsWith(ignoreTablePrefix.toLowerCase(Locale.getDefault()))) continue;
                keyName = keyName.substring(ignoreTablePrefix.length());
                break;
            }
        }
        if (this.genConfig.codeStyle == CodeStyle.DDD) {
            name = keyName + "Dto";
            packageName = this.assemblePackage("interfaces", "dto");
            path = Generator.getFilePath(this.genConfig.getSaveDirForVo(), Generator.getPathFromPackageName(packageName));
            this.voInfo = new GenFileInfo(name, packageName, path, keyName);
            name = keyName;
            if (this.genConfig.keepPrefixForPO) {
                name = keyNameIn;
            }
            packageName = this.assemblePackage("domain", module, "entity");
            path = Generator.getFilePath(saveDir, Generator.getPathFromPackageName(packageName));
            this.poInfo = new GenFileInfo(name, packageName, path, keyName);
            name = keyName + "Dao";
            packageName = this.assemblePackage("domain", module, "repository", "facade");
            path = Generator.getFilePath(saveDir, Generator.getPathFromPackageName(packageName));
            this.daoInfo = new GenFileInfo(name, packageName, path, keyName);
        } else {
            name = keyName + "Vo";
            packageName = this.assemblePackage(module, "vo");
            path = Generator.getFilePath(this.genConfig.getSaveDirForVo(), Generator.getPathFromPackageName(packageName));
            this.voInfo = new GenFileInfo(name, packageName, path, keyName);
            name = keyName;
            if (this.genConfig.keepPrefixForPO) {
                name = keyNameIn;
            }
            packageName = this.assemblePackage(module, "po");
            path = Generator.getFilePath(saveDir, Generator.getPathFromPackageName(packageName));
            this.poInfo = new GenFileInfo(name, packageName, path, keyName);
            name = keyName + "Dao";
            packageName = this.assemblePackage(module, "dao");
            path = Generator.getFilePath(saveDir, Generator.getPathFromPackageName(packageName));
            this.daoInfo = new GenFileInfo(name, packageName, path, keyName);
        }
        name = keyName + "BaseDao";
        packageName = Generator.assembleXmlPackage(module);
        String xmlPath = Generator.getFilePath(this.genConfig.getSaveDirForXml(), "base");
        path = Generator.getFilePath(xmlPath, Generator.getPathFromPackageName(packageName));
        this.baseMapperXmlInfo = new GenFileInfo(name, packageName, path, keyName);
        name = keyName + "Dao";
        packageName = Generator.assembleXmlPackage(module);
        xmlPath = Generator.getFilePath(this.genConfig.getSaveDirForXml(), "custom");
        path = Generator.getFilePath(xmlPath, Generator.getPathFromPackageName(packageName));
        this.mapperXmlInfo = new GenFileInfo(name, packageName, path, keyName);
    }

    @Override
    protected void run(Table table, String module) throws IOException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_27);
        cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(Generator.class, "/templates"));
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        log.info("============\u5904\u7406\u8868" + table.getName() + "==================");
        if (table.getPrimaryKeys().isEmpty()) {
            if (this.genConfig.isUseFirstCloumnAsPK() && !table.getColumns().isEmpty()) {
                Column firstColumn = table.getColumns().get(0);
                PrimaryKey pk = new PrimaryKey();
                pk.setColumnName(firstColumn.getName());
                pk.setKeySeq(1);
                pk.setPkName(firstColumn.getName());
                table.getPrimaryKeys().add(pk);
                log.info("\u8868{}\u6ca1\u6709\u4e3b\u952e\u5b57\u6bb5\uff0c\u4f7f\u7528\u7b2c\u4e00\u4e2a\u5b57\u6bb5\u4f5c\u4e3a\u4e3b\u952e.", (Object)table.getName(), (Object)table.getColumns().get(0).getName());
            } else {
                log.info("\u8868{}\u6ca1\u6709\u4e3b\u952e\u5b57\u6bb5\uff0c\u5ffd\u7565\u751f\u6210\uff0c\u8bf7\u624b\u5de5\u7f16\u5199.", (Object)table.getName());
                return;
            }
        }
        String beanName = GeneratorUtils.getObjectName(table.getName());
        this.resetFileInfo(beanName, module);
        this.fileOvervide = false;
        if ((this.containsGenType(GenType.VO) || this.containsGenType(GenType.DTO) && this.genConfig.getCodeStyle() == CodeStyle.DDD) && this.validFile(this.voInfo.getPath(), this.voInfo.getName(), ".java")) {
            new VoExecuter(cfg, this.genConfig, this.voInfo).build(table);
        }
        this.fileOvervide = true;
        if (this.containsGenType(GenType.PO) && this.validFile(this.poInfo.getPath(), this.poInfo.getName(), ".java")) {
            new PoExecuter(cfg, this.genConfig, this.poInfo).build(table);
        }
        this.fileOvervide = false;
        if (this.containsGenType(GenType.DAO) && this.validFile(this.daoInfo.getPath(), this.daoInfo.getName(), ".java")) {
            new DaoExecuter(cfg, this.genConfig, this.daoInfo, this.poInfo).build(table);
        }
        this.fileOvervide = true;
        if (this.containsGenType(GenType.BASE_MAPPER_XML) && this.validFile(this.baseMapperXmlInfo.getPath(), this.baseMapperXmlInfo.getName(), ".xml")) {
            new MyBatisBaseXmlExecuter(cfg, this.genConfig, this.baseMapperXmlInfo, this.daoInfo, this.poInfo, this.voInfo).build(table);
        }
        this.fileOvervide = false;
        if (this.containsGenType(GenType.MAPPER_XML) && this.validFile(this.mapperXmlInfo.getPath(), this.mapperXmlInfo.getName(), ".xml")) {
            new MyBatisCustomXmlExecuter(cfg, this.genConfig, this.mapperXmlInfo, this.daoInfo).build(table);
        }
    }

    @Override
    protected void runCommon() throws IOException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_27);
        cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(Generator.class, "/templates"));
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        this.fileOvervide = true;
        if (this.containsGenType(GenType.BASE_MAPPER_XML) && this.validFile(this.genConfig.getSaveDirForXml(), "base/common", ".xml")) {
            new MyBatisBaseCommonXmlExecuter(cfg, this.genConfig).build();
        }
        this.fileOvervide = false;
        if (this.containsGenType(GenType.MAPPER_XML) && this.validFile(this.genConfig.getSaveDirForXml(), "common/common", ".xml")) {
            new MyBatisCustomCommonXmlExecuter(cfg, this.genConfig).build();
        }
    }
}

