/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis.generator.executer;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import ins.framework.mybatis.generator.GenConfig;
import ins.framework.mybatis.generator.GenFileInfo;
import ins.framework.mybatis.generator.executer.TableBaseExecuter;
import ins.framework.mybatis.generator.freemarker.FreeMarkerUtils;
import ins.framework.mybatis.generator.schema.Column;
import ins.framework.mybatis.generator.schema.PrimaryKey;
import ins.framework.mybatis.generator.schema.Table;
import ins.framework.mybatis.generator.util.TypeUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaoExecuter
extends TableBaseExecuter {
    private static final Logger log = LoggerFactory.getLogger(DaoExecuter.class);
    private GenFileInfo daoInfo;
    private GenFileInfo poInfo;
    private Configuration cfg;

    public DaoExecuter(Configuration cfg, GenConfig genConfig, GenFileInfo daoInfo, GenFileInfo poInfo) {
        super(genConfig);
        this.cfg = cfg;
        this.daoInfo = daoInfo;
        this.poInfo = poInfo;
    }

    @Override
    public void build(Table table) throws IOException {
        List<PrimaryKey> primaryKeys = table.getPrimaryKeys();
        String idType = "";
        boolean isUnionKey = false;
        if (primaryKeys.isEmpty()) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u65e0\u4e3b\u952e\u7684\u8868");
        }
        if (primaryKeys.size() == 1) {
            String columnName = primaryKeys.get(0).getColumnName();
            for (Column column : table.getKeyColumns()) {
                if (!column.getName().equalsIgnoreCase(columnName)) continue;
                idType = TypeUtils.processType(column.getType());
                break;
            }
        } else {
            isUnionKey = true;
            idType = this.poInfo.getName() + "Key";
        }
        File targetFile = new File(this.daoInfo.getPath(), this.daoInfo.getName() + ".java");
        HashMap<Object, Object> root = new HashMap<Object, Object>();
        root.put("daoInfo", this.daoInfo);
        root.put("table", table);
        root.put("poInfo", this.poInfo);
        root.put("idType", idType);
        root.put("isUnionKey", isUnionKey);
        FreeMarkerUtils.registMethod(root);
        try (BufferedWriter bw = Files.newBufferedWriter(Paths.get(targetFile.toURI()), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            Template template = this.cfg.getTemplate("dao.ftlh");
            template.process(root, (Writer)bw);
            log.info("Generate Dao file {}", (Object)targetFile.getAbsolutePath());
        }
        catch (TemplateException e) {
            log.warn("{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

