/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis.generator.executer;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import ins.framework.mybatis.generator.GenConfig;
import ins.framework.mybatis.generator.executer.CommonBaseExecuter;
import ins.framework.mybatis.generator.freemarker.FreeMarkerUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBatisBaseCommonXmlExecuter
extends CommonBaseExecuter {
    private static final Logger log = LoggerFactory.getLogger(MyBatisBaseCommonXmlExecuter.class);
    private Configuration cfg;

    public MyBatisBaseCommonXmlExecuter(Configuration cfg, GenConfig genConfig) {
        super(genConfig);
        this.cfg = cfg;
    }

    @Override
    public void build() throws IOException {
        File targetFile = new File(this.genConfig.getSaveDirForXml(), "base/CommonBaseDao.xml");
        HashMap<Object, Object> root = new HashMap<Object, Object>();
        root.put("genConfig", this.genConfig);
        FreeMarkerUtils.registMethod(root);
        try (BufferedWriter bw = Files.newBufferedWriter(Paths.get(targetFile.toURI()), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            Template template = this.cfg.getTemplate("mybatis-base-common-mapper.ftlh");
            template.process(root, (Writer)bw);
            log.info("Generate mybatis base common mapper file {}", (Object)targetFile.getAbsolutePath());
        }
        catch (TemplateException e) {
            log.warn("{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

