/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis.generator.executer;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import ins.framework.mybatis.generator.GenConfig;
import ins.framework.mybatis.generator.GenFileInfo;
import ins.framework.mybatis.generator.executer.TableBaseExecuter;
import ins.framework.mybatis.generator.freemarker.FreeMarkerUtils;
import ins.framework.mybatis.generator.schema.Column;
import ins.framework.mybatis.generator.schema.PrimaryKey;
import ins.framework.mybatis.generator.schema.Table;
import ins.framework.mybatis.generator.util.GeneratorUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBatisBaseXmlExecuter
extends TableBaseExecuter {
    private static final Logger log = LoggerFactory.getLogger(MyBatisBaseXmlExecuter.class);
    private GenFileInfo baseMapperXmlInfo;
    private GenFileInfo daoInfo;
    private GenFileInfo poInfo;
    private GenFileInfo voInfo;
    private Configuration cfg;

    public MyBatisBaseXmlExecuter(Configuration cfg, GenConfig genConfig, GenFileInfo baseMapperXmlInfo, GenFileInfo daoInfo, GenFileInfo poInfo, GenFileInfo voInfo) {
        super(genConfig);
        this.cfg = cfg;
        this.baseMapperXmlInfo = baseMapperXmlInfo;
        this.daoInfo = daoInfo;
        this.poInfo = poInfo;
        this.voInfo = voInfo;
    }

    @Override
    public void build(Table table) throws IOException {
        List<PrimaryKey> primaryKeys = table.getPrimaryKeys();
        boolean isUnionKey = false;
        if (primaryKeys.isEmpty()) {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u65e0\u4e3b\u952e\u7684\u8868");
        }
        isUnionKey = primaryKeys.size() != 1;
        ArrayList<Column> updateColumns = new ArrayList<Column>();
        String[] ignoreColumnNamesWhenUpdate = this.genConfig.getIgnoreColumnNamesWhenUpdate();
        HashSet<String> ignoreColumnNamesWhenUpdateSet = new HashSet<String>();
        if (ignoreColumnNamesWhenUpdate != null) {
            for (String columnName : ignoreColumnNamesWhenUpdate) {
                ignoreColumnNamesWhenUpdateSet.add(columnName.toLowerCase(Locale.US));
            }
        }
        ArrayList<Column> whereColumns = new ArrayList<Column>();
        whereColumns.addAll(table.getKeyColumns());
        for (Column column : table.getNonKeyColumns()) {
            String columnName;
            columnName = column.getName().toLowerCase(Locale.US);
            if (!ignoreColumnNamesWhenUpdateSet.contains(columnName)) {
                updateColumns.add(column);
            }
            if (!this.genConfig.isTkeySupport() || !"tkey".equalsIgnoreCase(columnName)) continue;
            whereColumns.add(column);
        }
        PrimaryKey primaryKey = primaryKeys.get(0);
        HashMap<Object, Object> root = new HashMap<Object, Object>();
        root.put("genConfig", this.genConfig);
        root.put("daoInfo", this.daoInfo);
        root.put("poInfo", this.poInfo);
        root.put("voInfo", this.voInfo);
        root.put("table", table);
        root.put("updateColumns", updateColumns);
        root.put("whereColumns", whereColumns);
        root.put("primaryKey", primaryKey);
        root.put("isAutoIncrementPK", GeneratorUtils.isAutoIncrementPK(table));
        root.put("hasOperateTimeForHis", GeneratorUtils.hasColumn(table, this.genConfig.getOperateTimeForHisName()));
        boolean hasVersionField = false;
        String versionFieldName = this.genConfig.getVersionName();
        for (Column column : table.getColumns()) {
            if (!column.getName().equalsIgnoreCase(this.genConfig.getVersionName())) continue;
            hasVersionField = true;
            versionFieldName = column.getName();
            break;
        }
        root.put("hasVersionField", hasVersionField);
        root.put("versionFieldName", versionFieldName);
        FreeMarkerUtils.registMethod(root);
        String tempFile = "mybatis-base-mapper.ftlh";
        if (isUnionKey) {
            tempFile = "mybatis-base-mapper-unionkey.ftlh";
        }
        File targetFile = new File(this.baseMapperXmlInfo.getPath(), this.baseMapperXmlInfo.getName() + ".xml");
        try (BufferedWriter bw = Files.newBufferedWriter(Paths.get(targetFile.toURI()), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            Template template = this.cfg.getTemplate(tempFile);
            template.process(root, (Writer)bw);
            log.info("Generate mybatis base mapper file {}", (Object)targetFile.getAbsolutePath());
        }
        catch (TemplateException e) {
            log.warn("{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

