/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis.generator.executer;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import ins.framework.mybatis.generator.GenConfig;
import ins.framework.mybatis.generator.GenFileInfo;
import ins.framework.mybatis.generator.executer.TableBaseExecuter;
import ins.framework.mybatis.generator.freemarker.FreeMarkerUtils;
import ins.framework.mybatis.generator.schema.Table;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBatisCustomXmlExecuter
extends TableBaseExecuter {
    private static final Logger log = LoggerFactory.getLogger(MyBatisCustomXmlExecuter.class);
    private GenFileInfo mapperXmlInfo;
    private GenFileInfo daoInfo;
    private Configuration cfg;

    public MyBatisCustomXmlExecuter(Configuration cfg, GenConfig genConfig, GenFileInfo mapperXmlInfo, GenFileInfo daoInfo) {
        super(genConfig);
        this.cfg = cfg;
        this.mapperXmlInfo = mapperXmlInfo;
        this.daoInfo = daoInfo;
    }

    @Override
    public void build(Table table) throws IOException {
        File targetFile = new File(this.mapperXmlInfo.getPath(), this.mapperXmlInfo.getName() + ".xml");
        HashMap<Object, Object> root = new HashMap<Object, Object>();
        root.put("genConfig", this.genConfig);
        root.put("daoInfo", this.daoInfo);
        root.put("table", table);
        FreeMarkerUtils.registMethod(root);
        try (BufferedWriter bw = Files.newBufferedWriter(Paths.get(targetFile.toURI()), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            Template template = this.cfg.getTemplate("mybatis-custom-mapper.ftlh");
            template.process(root, (Writer)bw);
            log.info("Generate mybatis custom mapper file {}", (Object)targetFile.getAbsolutePath());
        }
        catch (TemplateException e) {
            log.warn("{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

