/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis.generator.executer;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import ins.framework.mybatis.generator.GenConfig;
import ins.framework.mybatis.generator.GenFileInfo;
import ins.framework.mybatis.generator.executer.TableBaseExecuter;
import ins.framework.mybatis.generator.freemarker.FreeMarkerUtils;
import ins.framework.mybatis.generator.schema.Column;
import ins.framework.mybatis.generator.schema.Table;
import ins.framework.mybatis.generator.util.GeneratorUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoExecuter
extends TableBaseExecuter {
    private static final Logger log = LoggerFactory.getLogger(PoExecuter.class);
    private GenFileInfo poInfo;
    private Configuration cfg;
    private static final String CONTAINS_DATE = "containsDate";
    private static final String CONTAINS_BIGDECIMAL = "containsBigDecimal";

    public PoExecuter(Configuration cfg, GenConfig genConfig, GenFileInfo poInfo) {
        super(genConfig);
        this.cfg = cfg;
        this.poInfo = poInfo;
    }

    @Override
    public void build(Table table) throws IOException {
        ArrayList<Column> extKeyColumns = new ArrayList<Column>();
        ArrayList<Column> extNonKeyColumns = new ArrayList<Column>();
        extKeyColumns.addAll(table.getKeyColumns());
        extNonKeyColumns.addAll(table.getNonKeyColumns());
        if (this.genConfig.isTkeySupport()) {
            table.getNonKeyColumns().stream().filter(column -> "tkey".equalsIgnoreCase(column.getName())).anyMatch(column -> extKeyColumns.add((Column)column));
            extNonKeyColumns.clear();
            for (Column column2 : table.getColumns()) {
                if (extKeyColumns.contains(column2)) continue;
                extNonKeyColumns.add(column2);
            }
        }
        HashMap<Object, Object> root = new HashMap<Object, Object>();
        root.put("poInfo", this.poInfo);
        root.put("table", table);
        root.put("extKeyColumns", extKeyColumns);
        root.put("extNonKeyColumns", extNonKeyColumns);
        FreeMarkerUtils.registMethod(root);
        if (table.getPrimaryKeys().size() == 1) {
            this.buildPo(root, table);
        } else {
            this.buildUnionKeyPo(root, table);
            this.buildUnionPo(root, table);
        }
    }

    public void buildPo(Map<Object, Object> root, Table table) throws IOException {
        File targetFile = new File(this.poInfo.getPath(), this.poInfo.getName() + ".java");
        List<String> types = GeneratorUtils.getTableColumnTypes(table);
        root.put(CONTAINS_DATE, GeneratorUtils.containsDate(types));
        root.put(CONTAINS_BIGDECIMAL, GeneratorUtils.containsBigDecimal(types));
        this.buildFile(root, targetFile, "po.ftlh", "PO");
    }

    public void buildUnionKeyPo(Map<Object, Object> root, Table table) throws IOException {
        String keyPoName = this.poInfo.getName() + "Key";
        File targetFile = new File(this.poInfo.getPath(), keyPoName + ".java");
        List<String> types = this.genConfig.isTkeySupport() ? GeneratorUtils.getTablePrimaryKeyTypes(table, new String[]{"tkey"}) : GeneratorUtils.getTablePrimaryKeyTypes(table);
        root.put(CONTAINS_DATE, GeneratorUtils.containsDate(types));
        root.put(CONTAINS_BIGDECIMAL, GeneratorUtils.containsBigDecimal(types));
        this.buildFile(root, targetFile, "unionkeypo.ftlh", "Union PO Key");
    }

    public void buildUnionPo(Map<Object, Object> root, Table table) throws IOException {
        File targetFile = new File(this.poInfo.getPath(), this.poInfo.getName() + ".java");
        List<String> types = GeneratorUtils.getTableColumnTypes(table);
        root.put(CONTAINS_DATE, GeneratorUtils.containsDate(types));
        root.put(CONTAINS_BIGDECIMAL, GeneratorUtils.containsBigDecimal(types));
        this.buildFile(root, targetFile, "unionpo.ftlh", "Union PO");
    }

    public void buildFile(Map<Object, Object> root, File targetFile, String ftlhFileName, String desc) throws IOException {
        try (BufferedWriter bw = Files.newBufferedWriter(Paths.get(targetFile.toURI()), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);){
            Template template = this.cfg.getTemplate(ftlhFileName);
            template.process(root, (Writer)bw);
            log.info("Generate {} file {}", (Object)desc, (Object)targetFile.getAbsolutePath());
        }
        catch (TemplateException e) {
            log.warn("{}", (Object)e.getMessage(), (Object)e);
        }
    }
}

