/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis.generator.util;

import ins.framework.mybatis.generator.schema.Column;
import ins.framework.mybatis.generator.schema.PrimaryKey;
import ins.framework.mybatis.generator.schema.Table;
import ins.framework.mybatis.generator.util.WordFileUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public final class GeneratorUtils {
    private GeneratorUtils() {
    }

    public static List<String> getTableColumnTypes(Table table) {
        ArrayList<String> types = new ArrayList<String>();
        List<Column> columns = table.getColumns();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            Column column = columns.get(i);
            types.add(column.getType());
        }
        return types;
    }

    public static List<String> getTablePrimaryKeyTypes(Table table) {
        ArrayList<String> types = new ArrayList<String>();
        List<Column> columns = table.getColumns();
        HashMap<String, String> columnTypeMap = new HashMap<String, String>();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            Column column = columns.get(i);
            columnTypeMap.put(column.getName(), column.getType());
        }
        List<PrimaryKey> primaryKeys = table.getPrimaryKeys();
        size = primaryKeys.size();
        for (int i = 0; i < size; ++i) {
            PrimaryKey primaryKey = primaryKeys.get(i);
            types.add((String)columnTypeMap.get(primaryKey.getColumnName()));
        }
        return types;
    }

    public static List<String> getTablePrimaryKeyTypes(Table table, String[] extPKs) {
        ArrayList<String> types = new ArrayList<String>();
        List<Column> columns = table.getColumns();
        HashMap<String, String> columnTypeMap = new HashMap<String, String>();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            Column column = columns.get(i);
            columnTypeMap.put(column.getName(), column.getType());
        }
        List<PrimaryKey> primaryKeys = table.getPrimaryKeys();
        size = primaryKeys.size();
        for (int i = 0; i < size; ++i) {
            PrimaryKey primaryKey = primaryKeys.get(i);
            types.add((String)columnTypeMap.get(primaryKey.getColumnName()));
        }
        if (extPKs != null) {
            for (String pk : extPKs) {
                if (!columnTypeMap.containsKey(pk)) continue;
                types.add((String)columnTypeMap.get(pk));
            }
        }
        return types;
    }

    public static boolean hasColumn(Table table, String columnName) {
        boolean result = false;
        List<Column> columns = table.getColumns();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            Column column = columns.get(i);
            if (!GeneratorUtils.getObjectName(column.getName()).equalsIgnoreCase(columnName)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static List<Column> getTablePrimaryKeysColumns(Table table) {
        HashMap<String, Column> columnMap = new HashMap<String, Column>();
        List<Column> columns = table.getColumns();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            Column column = columns.get(i);
            columnMap.put(column.getName().toLowerCase(Locale.getDefault()), column);
        }
        ArrayList<Column> result = new ArrayList<Column>();
        List<PrimaryKey> primaryKeys = table.getPrimaryKeys();
        size = primaryKeys.size();
        for (int i = 0; i < size; ++i) {
            PrimaryKey primaryKey = primaryKeys.get(i);
            result.add((Column)columnMap.get(primaryKey.getColumnName().toLowerCase(Locale.getDefault())));
        }
        return result;
    }

    public static String getKeyProperty(Table table) {
        Column column;
        List<Column> primaryKeysColumns = GeneratorUtils.getTablePrimaryKeysColumns(table);
        String result = "";
        if (primaryKeysColumns.size() == 1 && (column = primaryKeysColumns.get(0)).isAutoIncrement()) {
            result = column.getName();
        }
        return result;
    }

    public static boolean isAutoIncrementPK(Table table) {
        Column column;
        List<Column> primaryKeysColumns = GeneratorUtils.getTablePrimaryKeysColumns(table);
        return primaryKeysColumns.size() == 1 && (column = primaryKeysColumns.get(0)).isAutoIncrement();
    }

    public static List<String> getTablePrimaryKeysCloumnNames(Table table) {
        ArrayList<String> result = new ArrayList<String>();
        List<PrimaryKey> primaryKeys = table.getPrimaryKeys();
        int size = primaryKeys.size();
        for (int i = 0; i < size; ++i) {
            PrimaryKey primaryKey = primaryKeys.get(i);
            result.add(primaryKey.getColumnName().toLowerCase(Locale.getDefault()));
        }
        return result;
    }

    public static List<String> getTablePrimaryKeysTypes(Table table) {
        HashMap<String, String> columnMap = new HashMap<String, String>();
        List<Column> columns = table.getColumns();
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            Column column = columns.get(i);
            columnMap.put(column.getName().toLowerCase(Locale.getDefault()), column.getType());
        }
        ArrayList<String> types = new ArrayList<String>();
        List<PrimaryKey> primaryKeys = table.getPrimaryKeys();
        size = primaryKeys.size();
        for (int i = 0; i < size; ++i) {
            PrimaryKey primaryKey = primaryKeys.get(i);
            types.add((String)columnMap.get(primaryKey.getColumnName().toLowerCase(Locale.getDefault())));
        }
        return types;
    }

    public static boolean containsDate(List<String> types) {
        for (String type : types) {
            String t = type.toLowerCase(Locale.getDefault());
            if (!t.contains("date") && !t.contains("time")) continue;
            return true;
        }
        return false;
    }

    public static boolean containsBigDecimal(List<String> types) {
        for (String type : types) {
            if (!type.toLowerCase(Locale.getDefault()).contains("number") && !type.toLowerCase(Locale.getDefault()).contains("numeric") && !type.toLowerCase(Locale.getDefault()).contains("decimal")) continue;
            return true;
        }
        return false;
    }

    public static String getInstanceName(String field) {
        return WordFileUtils.getBeautyInstanceName(field);
    }

    public static String getObjectName(String field) {
        return WordFileUtils.getBeautyObjectName(field);
    }
}

