/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis;

import ins.framework.mybatis.PageParam;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class MybatisApiUtils {
    public static final int DEFAULT_PAGE_SIZE = 10;
    public static final int MAX_PAGE_SIZE = 3000;

    public static PageParam getPageParam() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        return MybatisApiUtils.getPageParam(request);
    }

    public static PageParam getPageParam(HttpServletRequest request) {
        int inPageSize = 0;
        int inPageNo = 0;
        int inTotalCount = 0;
        inPageNo = MybatisApiUtils.getParameterValue(request, "_pageNo", 1);
        if (inPageNo < 1) {
            inPageNo = 1;
        }
        if ((inPageSize = MybatisApiUtils.getParameterValue(request, "_pageSize", 10)) < 0) {
            inPageSize = 10;
        }
        if (inPageSize > 3000) {
            throw new IllegalArgumentException("pageSize exceeded maxPageSize[3000]");
        }
        PageParam pageParam = new PageParam(inPageNo, inPageSize);
        inTotalCount = MybatisApiUtils.getParameterValue(request, "_totalCount", 0);
        if (inTotalCount > 0) {
            pageParam.setContainsTotalCount(false);
        }
        return pageParam;
    }

    public static int getParameterValue(HttpServletRequest request, String name, int def) {
        String str = request.getParameter(name);
        int value = def;
        if (str != null) {
            value = Integer.parseInt(str, 10);
        }
        return value;
    }

    public String getParameterValue(HttpServletRequest request, String name, String def) {
        String str = request.getParameter(name);
        String value = def;
        if (str != null) {
            value = str;
        }
        return value;
    }
}

