/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis;

import ins.framework.mybatis.paginator.OffsetLimitInterceptor;
import ins.framework.mybatis.paginator.dialect.DB2Dialect;
import ins.framework.mybatis.paginator.dialect.H2Dialect;
import ins.framework.mybatis.paginator.dialect.HSQLDialect;
import ins.framework.mybatis.paginator.dialect.InformixDialect;
import ins.framework.mybatis.paginator.dialect.MySQLDialect;
import ins.framework.mybatis.paginator.dialect.OracleDialect;
import ins.framework.mybatis.paginator.dialect.PostgreSQLDialect;
import ins.framework.mybatis.paginator.dialect.SQLServerDialect;
import ins.framework.mybatis.paginator.dialect.SybaseDialect;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;

@Configuration
@EnableTransactionManagement
public class MybatisConfig
implements TransactionManagementConfigurer {
    private static final Logger log = LoggerFactory.getLogger(MybatisConfig.class);
    @Autowired
    private DataSource dataSource;

    @Bean
    public OffsetLimitInterceptor offsetLimitInterceptor() throws SQLException {
        OffsetLimitInterceptor offsetLimitInterceptor = new OffsetLimitInterceptor();
        try (Connection connection = this.dataSource.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            String databaseProductName = metaData.getDatabaseProductName();
            String dbName = databaseProductName.toLowerCase();
            if (dbName.contains("mysql")) {
                offsetLimitInterceptor.setDialectClass(MySQLDialect.class.getName());
            } else if (dbName.contains("oracle")) {
                offsetLimitInterceptor.setDialectClass(OracleDialect.class.getName());
            } else if (dbName.contains("db2")) {
                offsetLimitInterceptor.setDialectClass(DB2Dialect.class.getName());
            } else if (dbName.contains("postgre")) {
                offsetLimitInterceptor.setDialectClass(PostgreSQLDialect.class.getName());
            } else if (dbName.contains("sql server")) {
                offsetLimitInterceptor.setDialectClass(SQLServerDialect.class.getName());
            } else if (dbName.contains("h2")) {
                offsetLimitInterceptor.setDialectClass(H2Dialect.class.getName());
            } else if (dbName.contains("hsql")) {
                offsetLimitInterceptor.setDialectClass(HSQLDialect.class.getName());
            } else if (dbName.contains("sybase")) {
                offsetLimitInterceptor.setDialectClass(SybaseDialect.class.getName());
            } else if (dbName.indexOf("sinoregal") != -1) {
                offsetLimitInterceptor.setDialectClass(InformixDialect.class.getName());
            } else if (dbName.indexOf("argon") != -1) {
                offsetLimitInterceptor.setDialectClass(InformixDialect.class.getName());
            } else if (dbName.indexOf("ibm informix") != -1) {
                offsetLimitInterceptor.setDialectClass(InformixDialect.class.getName());
            } else {
                throw new IllegalArgumentException("Unsupport Database [" + databaseProductName + "]");
            }
            log.info("Current databaseProductName is [" + databaseProductName + "]");
        }
        return offsetLimitInterceptor;
    }

    @Bean
    public PlatformTransactionManager annotationDrivenTransactionManager() {
        return new DataSourceTransactionManager(this.dataSource);
    }
}

