/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis.paginator;

import ins.framework.mybatis.Page;
import ins.framework.mybatis.PageParam;
import ins.framework.mybatis.paginator.dialect.Dialect;
import ins.framework.mybatis.paginator.domain.Paginator;
import ins.framework.mybatis.util.SQLHelper;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class OffsetLimitInterceptor
implements Interceptor {
    private static Logger logger = LoggerFactory.getLogger(OffsetLimitInterceptor.class);
    static final int MAPPED_STATEMENT_INDEX = 0;
    static final int PARAMETER_INDEX = 1;
    static final int ROWBOUNDS_INDEX = 2;
    static final int RESULT_HANDLER_INDEX = 3;
    String dialectClass;
    boolean asyncTotalCount = false;

    public Object intercept(Invocation invocation) throws Throwable {
        Integer count;
        Dialect dialect;
        Executor executor = (Executor)invocation.getTarget();
        Object[] queryArgs = invocation.getArgs();
        MappedStatement ms = (MappedStatement)queryArgs[0];
        Object parameter = queryArgs[1];
        RowBounds rowBounds = (RowBounds)queryArgs[2];
        PageParam pageParam = new PageParam(rowBounds);
        if (pageParam.getOffset() == 0 && pageParam.getLimit() == Integer.MAX_VALUE && pageParam.getOrders().isEmpty()) {
            return invocation.proceed();
        }
        try {
            Class<?> clazz = Class.forName(this.dialectClass);
            Constructor<?> constructor = clazz.getConstructor(MappedStatement.class, Object.class, PageParam.class);
            dialect = (Dialect)constructor.newInstance(ms, parameter, pageParam);
        }
        catch (Exception e) {
            throw new ClassNotFoundException("Cannot create dialect instance: " + this.dialectClass, e);
        }
        BoundSql boundSql = ms.getBoundSql(parameter);
        queryArgs[0] = this.copyFromNewSql(ms, boundSql, dialect.getPageSQL(), dialect.getParameterMappings(), dialect.getParameterObject());
        queryArgs[1] = dialect.getParameterObject();
        queryArgs[2] = new RowBounds(0, Integer.MAX_VALUE);
        List result = (List)invocation.proceed();
        Cache cache = ms.getCache();
        if (cache != null && ms.isUseCache() && ms.getConfiguration().isCacheEnabled()) {
            CacheKey cacheKey = executor.createCacheKey(ms, parameter, (RowBounds)new PageParam(), this.copyFromBoundSql(ms, boundSql, dialect.getCountSQL(), boundSql.getParameterMappings(), boundSql.getParameterObject()));
            count = (Integer)cache.getObject((Object)cacheKey);
            if (count == null) {
                count = SQLHelper.getCount(ms, executor.getTransaction(), parameter, boundSql, dialect);
                cache.putObject((Object)cacheKey, (Object)count);
            }
        } else {
            count = SQLHelper.getCount(ms, executor.getTransaction(), parameter, boundSql, dialect);
        }
        Paginator paginator = new Paginator(pageParam.getPage(), pageParam.getLimit(), count);
        return new Page(result, paginator);
    }

    private MappedStatement copyFromNewSql(MappedStatement ms, BoundSql boundSql, String sql, List<ParameterMapping> parameterMappings, Object parameter) {
        BoundSql newBoundSql = this.copyFromBoundSql(ms, boundSql, sql, parameterMappings, parameter);
        return this.copyFromMappedStatement(ms, new BoundSqlSqlSource(newBoundSql));
    }

    private BoundSql copyFromBoundSql(MappedStatement ms, BoundSql boundSql, String sql, List<ParameterMapping> parameterMappings, Object parameter) {
        BoundSql newBoundSql = new BoundSql(ms.getConfiguration(), sql, parameterMappings, parameter);
        for (ParameterMapping mapping : boundSql.getParameterMappings()) {
            String prop = mapping.getProperty();
            if (!boundSql.hasAdditionalParameter(prop)) continue;
            newBoundSql.setAdditionalParameter(prop, boundSql.getAdditionalParameter(prop));
        }
        return newBoundSql;
    }

    private MappedStatement copyFromMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
            StringBuilder keyProperties = new StringBuilder();
            for (String keyProperty : ms.getKeyProperties()) {
                keyProperties.append(keyProperty).append(",");
            }
            keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
            builder.keyProperty(keyProperties.toString());
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        String dialectClassName = properties.getProperty("dialectClass");
        this.setDialectClass(dialectClassName);
    }

    public void setDialectClass(String dialectClass) {
        logger.debug("dialectClass: {} ", (Object)dialectClass);
        this.dialectClass = dialectClass;
    }

    public static class BoundSqlSqlSource
    implements SqlSource {
        BoundSql boundSql;

        public BoundSqlSqlSource(BoundSql boundSql) {
            this.boundSql = boundSql;
        }

        public BoundSql getBoundSql(Object parameterObject) {
            return this.boundSql;
        }
    }
}

