/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis.paginator.dialect;

import ins.framework.mybatis.Order;
import ins.framework.mybatis.PageParam;
import ins.framework.mybatis.util.SQLHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.property.PropertyTokenizer;
import org.apache.ibatis.reflection.wrapper.ObjectWrapper;
import org.apache.ibatis.type.SimpleTypeRegistry;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class Dialect {
    protected TypeHandlerRegistry typeHandlerRegistry;
    protected MappedStatement mappedStatement;
    protected PageParam pageParam;
    protected Object parameterObject;
    protected List<ParameterMapping> parameterMappings;
    protected Map<String, Object> pageParameters = new HashMap<String, Object>();
    private String pageSQL;
    private String countSQL;

    public Dialect(MappedStatement mappedStatement, Object parameterObject, PageParam pageParam) {
        this.mappedStatement = mappedStatement;
        this.parameterObject = parameterObject;
        this.pageParam = pageParam;
        this.typeHandlerRegistry = mappedStatement.getConfiguration().getTypeHandlerRegistry();
        this.init();
    }

    protected void init() {
        BoundSql boundSql = this.mappedStatement.getBoundSql(this.parameterObject);
        this.parameterMappings = new ArrayList<ParameterMapping>(boundSql.getParameterMappings());
        if (this.parameterObject instanceof Map) {
            this.pageParameters.putAll((Map)this.parameterObject);
        } else if (this.parameterObject != null) {
            Class<?> cls = this.parameterObject.getClass();
            if (cls.isPrimitive() || cls.isArray() || SimpleTypeRegistry.isSimpleType(cls) || Enum.class.isAssignableFrom(cls) || Collection.class.isAssignableFrom(cls)) {
                for (ParameterMapping parameterMapping : this.parameterMappings) {
                    this.pageParameters.put(parameterMapping.getProperty(), this.parameterObject);
                }
            } else {
                MetaObject metaObject = this.mappedStatement.getConfiguration().newMetaObject(this.parameterObject);
                ObjectWrapper wrapper = metaObject.getObjectWrapper();
                for (ParameterMapping parameterMapping : this.parameterMappings) {
                    PropertyTokenizer prop = new PropertyTokenizer(parameterMapping.getProperty());
                    this.pageParameters.put(parameterMapping.getProperty(), wrapper.get(prop));
                }
            }
        }
        this.initSQL(boundSql.getSql().trim());
    }

    private void initSQL(String inSQL) {
        String sql = inSQL;
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        this.pageSQL = sql;
        if (this.pageParam.getOrders() != null && !this.pageParam.getOrders().isEmpty()) {
            this.pageSQL = this.getSortString(sql, this.pageParam.getOrders());
        }
        if (this.pageParam.getOffset() != 0 || this.pageParam.getLimit() != Integer.MAX_VALUE) {
            this.pageSQL = this.getLimitString(this.pageSQL, "__offset", this.pageParam.getOffset(), "__limit", this.pageParam.getLimit());
        }
        this.countSQL = this.getCountString(sql);
    }

    public List<ParameterMapping> getParameterMappings() {
        return this.parameterMappings;
    }

    public Object getParameterObject() {
        return this.pageParameters;
    }

    public String getPageSQL() {
        return this.pageSQL;
    }

    protected void setPageParameter(String name, Object value, Class<?> type) {
        ParameterMapping parameterMapping = new ParameterMapping.Builder(this.mappedStatement.getConfiguration(), name, type).build();
        this.parameterMappings.add(parameterMapping);
        this.pageParameters.put(name, value);
    }

    public String getCountSQL() {
        return this.countSQL;
    }

    protected String getLimitString(String sql, String offsetName, int offset, String limitName, int limit) {
        throw new UnsupportedOperationException("paged queries not supported");
    }

    protected String getCountString(String sql) {
        return "select count(1) from (" + SQLHelper.removeOrders(sql) + ") tmp_count";
    }

    protected String getSortString(String sql, List<Order> orders) {
        if (orders == null || orders.isEmpty()) {
            return sql;
        }
        StringBuilder buffer = new StringBuilder("select * from (").append(sql).append(") temp_order order by ");
        for (Order order : orders) {
            if (order == null) continue;
            buffer.append(order.toString()).append(", ");
        }
        buffer.delete(buffer.length() - 2, buffer.length());
        return buffer.toString();
    }
}

