/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis;

import ins.framework.mybatis.Order;
import ins.framework.mybatis.PageParam;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class MybatisApiUtils {
    public static final int DEFAULT_PAGE_SIZE = 10;
    public static final int MAX_PAGE_SIZE = 3000;

    public static PageParam getPageParam() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = null;
        if (attributes != null) {
            request = attributes.getRequest();
        }
        return MybatisApiUtils.getPageParam(request);
    }

    public static PageParam getPageParam(HttpServletRequest request) {
        int inTotalCount;
        int inPageSize;
        int inPageNo = MybatisApiUtils.getParameterValue(request, "_pageNo", 1);
        if (inPageNo < 1) {
            inPageNo = 1;
        }
        if ((inPageSize = MybatisApiUtils.getParameterValue(request, "_pageSize", 10)) < 0) {
            inPageSize = 10;
        }
        if (inPageSize > 3000) {
            throw new IllegalArgumentException("pageSize exceeded maxPageSize[3000]");
        }
        PageParam pageParam = new PageParam(inPageNo, inPageSize);
        List<Order> orders = MybatisApiUtils.getListOrders(request);
        if (orders != null) {
            pageParam.setOrders(orders);
        }
        if ((inTotalCount = MybatisApiUtils.getParameterValue(request, "_totalCount", 0)) > 0) {
            pageParam.setContainsTotalCount(false);
        }
        return pageParam;
    }

    public static List<Order> getListOrders(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        Enumeration parameters = request.getParameterNames();
        ArrayList<Order> orders = null;
        while (parameters.hasMoreElements()) {
            String currentKey;
            String currentProperty;
            String parameterKey = (String)parameters.nextElement();
            if (!parameterKey.contains("orders")) continue;
            StringBuilder currentCommon = new StringBuilder("orders[");
            int commonLength = currentCommon.length();
            Order.Direction currentDir = null;
            for (int initIndex = 0; initIndex != -1 && (currentProperty = request.getParameter(currentKey = currentCommon.append(initIndex).append("][property]").toString())) != null; ++initIndex) {
                String currentDirection;
                if (initIndex == 0) {
                    orders = new ArrayList<Order>();
                }
                if ((currentDirection = request.getParameter(currentKey = currentCommon.delete(commonLength, currentCommon.length()).append(initIndex).append("][direction]").toString())) != null) {
                    currentDir = Order.Direction.fromString(currentDirection);
                }
                currentKey = currentCommon.delete(commonLength, currentCommon.length()).append(initIndex).append("][orderExpr]").toString();
                String currentExp = request.getParameter(currentKey);
                Order order = new Order(currentProperty, currentDir, currentExp);
                orders.add(order);
            }
        }
        return orders;
    }

    public static int getParameterValue(HttpServletRequest request, String name, int def) {
        if (request == null) {
            return def;
        }
        String str = request.getParameter(name);
        int value = def;
        if (str != null) {
            value = Integer.parseInt(str, 10);
        }
        return value;
    }

    public String getParameterValue(HttpServletRequest request, String name, String def) {
        if (request == null) {
            return def;
        }
        String str = request.getParameter(name);
        String value = def;
        if (str != null) {
            value = str;
        }
        return value;
    }
}

