/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis;

import ins.framework.mybatis.Page;
import ins.framework.mybatis.PageParam;
import java.util.List;

public interface MybatisBaseDao<T, I> {
    public int insert(T var1);

    public int insertSelective(T var1);

    default public int insertBatch(List<T> entityList) {
        int rows = 0;
        if (entityList != null) {
            for (T t : entityList) {
                rows += this.insert(t);
            }
        }
        return rows;
    }

    default public int insertSelectiveBatch(List<T> entityList) {
        int rows = 0;
        if (entityList != null) {
            for (T t : entityList) {
                rows += this.insertSelective(t);
            }
        }
        return rows;
    }

    public int insertBatchBySQL(List<T> var1);

    public int deleteByPrimaryKey(I var1);

    public int deleteBatchByPrimaryKeys(List<I> var1);

    public int delete(T var1);

    public int deleteBatch(List<T> var1);

    public int updateByPrimaryKey(T var1);

    public int updateByPrimaryKeyWithVersion(T var1);

    default public int updateBatch(List<T> entityList) {
        int rows = 0;
        if (entityList != null) {
            for (T t : entityList) {
                rows += this.updateSelectiveByPrimaryKey(t);
            }
        }
        return rows;
    }

    default public int updateBatchWithVersion(List<T> entityList) {
        int rows = 0;
        if (entityList != null) {
            for (T t : entityList) {
                rows += this.updateSelectiveByPrimaryKeyWithVersion(t);
            }
        }
        return rows;
    }

    public int updateSelectiveByPrimaryKey(T var1);

    public int updateSelectiveByPrimaryKeyWithVersion(T var1);

    public T selectByPrimaryKey(I var1);

    public List<T> selectBatchByPrimaryKeys(List<I> var1);

    public List<T> selectBatch(List<T> var1);

    public Page<T> selectPage(PageParam var1, T var2);

    default public int save(T entity) {
        int rows = 0;
        rows = this.existsByEntity(entity) ? this.updateSelectiveByPrimaryKey(entity) : this.insertSelective(entity);
        return rows;
    }

    default public int saveWithVersion(T entity) {
        int rows = 0;
        rows = this.existsByEntity(entity) ? this.updateSelectiveByPrimaryKeyWithVersion(entity) : this.insertSelective(entity);
        return rows;
    }

    default public int saveBatch(List<T> entityList) {
        int rows = 0;
        for (T po : entityList) {
            rows += this.save(po);
        }
        return rows;
    }

    default public int saveBatchWithVersion(List<T> entityList) {
        int rows = 0;
        for (T po : entityList) {
            rows += this.saveWithVersion(po);
        }
        return rows;
    }

    public boolean exists(I var1);

    public boolean existsByEntity(T var1);
}

