/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis.paginator;

import ins.framework.auth.util.JwtAuthUtil;
import ins.framework.lang.Springs;
import ins.framework.mybatis.Page;
import ins.framework.mybatis.PageParam;
import ins.framework.mybatis.paginator.dialect.Dialect;
import ins.framework.mybatis.paginator.domain.Paginator;
import ins.framework.mybatis.util.ReflectHelper;
import ins.framework.mybatis.util.SQLHelper;
import ins.framework.saa.DataPowerService;
import ins.framework.saa.PowerIndicator;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class OffsetLimitInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(OffsetLimitInterceptor.class);
    public static final int MAPPED_STATEMENT_INDEX = 0;
    public static final int PARAMETER_INDEX = 1;
    public static final int ROWBOUNDS_INDEX = 2;
    public static final int RESULT_HANDLER_INDEX = 3;
    private String dialectClass;
    @Value(value="${saa.power:false}")
    private boolean power;
    @Value(value="${app.system-code:}")
    private String systemCode;
    @Autowired
    private JwtAuthUtil jwtAuthUtil;
    public static final ThreadLocal<String> powerSql = new ThreadLocal();

    public Object intercept(Invocation invocation) throws Throwable {
        Dialect dialect;
        Object[] queryArgs = invocation.getArgs();
        RowBounds rowBounds = (RowBounds)queryArgs[2];
        PageParam pageParam = new PageParam(rowBounds);
        if (pageParam.getOffset() == 0 && pageParam.getLimit() == Integer.MAX_VALUE && pageParam.getOrders().isEmpty()) {
            return invocation.proceed();
        }
        MappedStatement ms = (MappedStatement)queryArgs[0];
        Object parameter = queryArgs[1];
        BoundSql boundSql = ms.getBoundSql(parameter);
        boolean skipDataPower = (Boolean)PowerIndicator.get((String)"skipDataPower", (Object)false);
        if (this.power && !skipDataPower) {
            Object obj = Springs.getBean((String)"saaDataPowerService");
            String userCode = this.jwtAuthUtil.getUserCode();
            String sql = ((DataPowerService)obj).addDataPower(userCode, this.systemCode, boundSql.getSql());
            powerSql.set(sql);
            ReflectHelper.setFieldValue(boundSql, "sql", sql);
            ms = OffsetLimitInterceptor.copyFromMappedStatement(ms, new BoundSqlSqlSource(boundSql));
        }
        try {
            Class<?> clazz = Class.forName(this.dialectClass);
            Constructor<?> constructor = clazz.getConstructor(MappedStatement.class, Object.class, PageParam.class);
            dialect = (Dialect)constructor.newInstance(ms, parameter, pageParam);
        }
        catch (Exception e) {
            throw new ClassNotFoundException("Cannot create dialect instance: " + this.dialectClass, e);
        }
        queryArgs[0] = this.copyFromNewSql(dialect);
        queryArgs[2] = new RowBounds(0, Integer.MAX_VALUE);
        List result = (List)invocation.proceed();
        Integer count = 0;
        if (pageParam.isContainsTotalCount()) {
            Cache cache = ms.getCache();
            Executor executor = (Executor)invocation.getTarget();
            if (cache != null && ms.isUseCache() && ms.getConfiguration().isCacheEnabled()) {
                CacheKey cacheKey = executor.createCacheKey(ms, parameter, (RowBounds)new PageParam(), OffsetLimitInterceptor.copyCountFromBoundSql(dialect));
                count = (Integer)cache.getObject((Object)cacheKey);
                if (count == null) {
                    count = SQLHelper.getCount(ms, executor.getTransaction(), parameter, boundSql, dialect);
                    cache.putObject((Object)cacheKey, (Object)count);
                }
            } else {
                count = SQLHelper.getCount(ms, executor.getTransaction(), parameter, boundSql, dialect);
            }
        }
        Paginator paginator = new Paginator(pageParam.getPage(), pageParam.getLimit(), count);
        return new Page(result, paginator);
    }

    private MappedStatement copyFromNewSql(Dialect dialect) {
        BoundSql newBoundSql = new BoundSql(dialect.getMappedStatement().getConfiguration(), dialect.getPageSQL(), dialect.getParameterMappings(), dialect.getParameterObject());
        for (ParameterMapping mapping : dialect.getParameterMappings()) {
            String prop = mapping.getProperty();
            newBoundSql.setAdditionalParameter(prop, dialect.getAdditionalParameters().get(prop));
            log.debug("In copyFromNewSql,parameter [{}]=[{}]", (Object)prop, dialect.getAdditionalParameters().get(prop));
        }
        return OffsetLimitInterceptor.copyFromMappedStatement(dialect.getMappedStatement(), new BoundSqlSqlSource(newBoundSql));
    }

    private static BoundSql copyCountFromBoundSql(Dialect dialect) {
        BoundSql newBoundSql = new BoundSql(dialect.getMappedStatement().getConfiguration(), dialect.getCountSQL(), dialect.getParameterMappings(), dialect.getParameterObject());
        for (ParameterMapping mapping : dialect.getParameterMappings()) {
            String prop = mapping.getProperty();
            newBoundSql.setAdditionalParameter(prop, dialect.getAdditionalParameters().get(prop));
            log.debug("In copyCountFromBoundSql,parameter [{}]=[{}]", (Object)prop, dialect.getAdditionalParameters().get(prop));
        }
        return newBoundSql;
    }

    private static MappedStatement copyFromMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
            StringBuilder keyProperties = new StringBuilder();
            for (String keyProperty : ms.getKeyProperties()) {
                keyProperties.append(keyProperty).append(",");
            }
            keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
            builder.keyProperty(keyProperties.toString());
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        String dialectClassName = properties.getProperty("dialectClass");
        this.setDialectClass(dialectClassName);
    }

    public void setDialectClass(String dialectClass) {
        log.debug("dialectClass: {} ", (Object)dialectClass);
        this.dialectClass = dialectClass;
    }

    public static class BoundSqlSqlSource
    implements SqlSource {
        private BoundSql boundSql;

        public BoundSqlSqlSource(BoundSql boundSql) {
            this.boundSql = boundSql;
        }

        public BoundSql getBoundSql(Object parameterObject) {
            return this.boundSql;
        }
    }
}

