/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis.paginator.dialect;

import ins.framework.mybatis.PageParam;
import ins.framework.mybatis.paginator.dialect.Dialect;
import java.util.Locale;
import org.apache.ibatis.mapping.MappedStatement;

public class DB2Dialect
extends Dialect {
    public DB2Dialect(MappedStatement mappedStatement, Object parameterObject, PageParam pageParam) {
        super(mappedStatement, parameterObject, pageParam);
    }

    private static String getRowNumber(String sql) {
        StringBuilder rownumber = new StringBuilder(50).append("rownumber() over(");
        int orderByIndex = sql.toLowerCase(Locale.US).indexOf("order by");
        if (orderByIndex > 0 && !DB2Dialect.hasDistinct(sql)) {
            rownumber.append(sql.substring(orderByIndex));
        }
        rownumber.append(") as rownumber_,");
        return rownumber.toString();
    }

    private static boolean hasDistinct(String sql) {
        return sql.toLowerCase(Locale.US).indexOf("select distinct") >= 0;
    }

    @Override
    protected String getLimitString(String sql, String offsetName, int offset, String limitName, int limit) {
        int startOfSelect = sql.toLowerCase(Locale.US).indexOf("select");
        StringBuilder pagingSelect = new StringBuilder(sql.length() + 100).append(sql.substring(0, startOfSelect)).append("select * from ( select ").append(DB2Dialect.getRowNumber(sql));
        if (DB2Dialect.hasDistinct(sql)) {
            pagingSelect.append(" row_.* from ( ").append(sql.substring(startOfSelect)).append(" ) as row_");
        } else {
            pagingSelect.append(sql.substring(startOfSelect + 6));
        }
        pagingSelect.append(" ) as temp_ where rownumber_ ");
        if (offset > 0) {
            pagingSelect.append("between ?+1 and ?");
            this.setPageParameter(offsetName, offset, Integer.class);
            this.setPageParameter("__offsetEnd", offset + limit, Integer.class);
        } else {
            pagingSelect.append("<= ?");
            this.setPageParameter(limitName, limit, Integer.class);
        }
        return pagingSelect.toString();
    }
}

