/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis.paginator.dialect;

import ins.framework.mybatis.Order;
import ins.framework.mybatis.PageParam;
import ins.framework.mybatis.util.SQLHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.property.PropertyTokenizer;
import org.apache.ibatis.reflection.wrapper.ObjectWrapper;
import org.apache.ibatis.type.SimpleTypeRegistry;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class Dialect {
    protected TypeHandlerRegistry typeHandlerRegistry;
    protected MappedStatement mappedStatement;
    protected PageParam pageParam;
    protected Object parameterObject;
    protected List<ParameterMapping> parameterMappings;
    protected Map<String, Object> additionalParameters = new HashMap<String, Object>();
    private String pageSQL;
    private String countSQL;

    public Dialect(MappedStatement mappedStatement, Object parameterObject, PageParam pageParam) {
        this.mappedStatement = mappedStatement;
        this.parameterObject = parameterObject;
        this.pageParam = pageParam;
        this.typeHandlerRegistry = mappedStatement.getConfiguration().getTypeHandlerRegistry();
        this.init();
    }

    protected void init() {
        BoundSql boundSql = this.mappedStatement.getBoundSql(this.parameterObject);
        this.parameterMappings = new ArrayList<ParameterMapping>(boundSql.getParameterMappings());
        if (this.parameterObject instanceof Map) {
            this.additionalParameters.putAll((Map)this.parameterObject);
        } else if (this.parameterObject != null) {
            Class<?> cls = this.parameterObject.getClass();
            if (cls.isPrimitive() || cls.isArray() || SimpleTypeRegistry.isSimpleType(cls) || Enum.class.isAssignableFrom(cls) || Collection.class.isAssignableFrom(cls)) {
                for (ParameterMapping parameterMapping : this.parameterMappings) {
                    this.additionalParameters.put(parameterMapping.getProperty(), this.parameterObject);
                }
            } else {
                MetaObject metaObject = this.mappedStatement.getConfiguration().newMetaObject(this.parameterObject);
                ObjectWrapper wrapper = metaObject.getObjectWrapper();
                for (ParameterMapping parameterMapping : this.parameterMappings) {
                    PropertyTokenizer prop = new PropertyTokenizer(parameterMapping.getProperty());
                    String name = parameterMapping.getProperty();
                    if (name.indexOf(46) != -1) {
                        name = name.substring(0, name.indexOf(46));
                        this.additionalParameters.put(name, wrapper.findProperty(name, true));
                        continue;
                    }
                    this.additionalParameters.put(parameterMapping.getProperty(), wrapper.get(prop));
                }
            }
        }
        for (ParameterMapping parameterMapping : this.parameterMappings) {
            String name = parameterMapping.getProperty();
            Object value = boundSql.getAdditionalParameter(name);
            if (value == null) continue;
            this.additionalParameters.put(name, value);
        }
        this.initSQL(boundSql.getSql().trim());
    }

    private void initSQL(String inSQL) {
        String sql = inSQL;
        if (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        this.pageSQL = sql;
        if (this.pageParam.getOrders() != null && !this.pageParam.getOrders().isEmpty()) {
            this.pageSQL = this.getSortString(sql, this.pageParam.getOrders());
        }
        if (this.pageParam.getOffset() != 0 || this.pageParam.getLimit() != Integer.MAX_VALUE) {
            this.pageSQL = this.getLimitString(this.pageSQL, "__offset", this.pageParam.getOffset(), "__limit", this.pageParam.getLimit());
        }
        this.countSQL = this.getCountString(sql);
    }

    public MappedStatement getMappedStatement() {
        return this.mappedStatement;
    }

    public List<ParameterMapping> getParameterMappings() {
        return this.parameterMappings;
    }

    public Object getParameterObject() {
        return this.parameterObject;
    }

    public String getPageSQL() {
        return this.pageSQL;
    }

    protected void setPageParameter(String name, Object value, Class<?> type) {
        ParameterMapping parameterMapping = new ParameterMapping.Builder(this.mappedStatement.getConfiguration(), name, type).build();
        this.parameterMappings.add(parameterMapping);
        this.additionalParameters.put(name, value);
    }

    protected void setPageParameter(String name, Object value, Class<?> type, int index) {
        ParameterMapping parameterMapping = new ParameterMapping.Builder(this.mappedStatement.getConfiguration(), name, type).build();
        this.parameterMappings.add(index, parameterMapping);
        this.additionalParameters.put(name, value);
    }

    public String getCountSQL() {
        return this.countSQL;
    }

    public Map<String, Object> getAdditionalParameters() {
        return this.additionalParameters;
    }

    protected String getLimitString(String sql, String offsetName, int offset, String limitName, int limit) {
        throw new UnsupportedOperationException("paged queries not supported");
    }

    protected String getCountString(String sql) {
        StringBuilder buf = new StringBuilder();
        buf.append("select count(1) from (");
        buf.append(SQLHelper.removeOrders(sql));
        buf.append(") tmp_count");
        return buf.toString();
    }

    protected String getSortString(String sql, List<Order> orders) {
        if (orders == null || orders.isEmpty()) {
            return sql;
        }
        List resultMaps = this.mappedStatement.getResultMaps();
        HashMap<String, String> propertyColumn = null;
        if (resultMaps != null && resultMaps.get(0) != null) {
            propertyColumn = new HashMap<String, String>();
            List resultMappings = ((ResultMap)resultMaps.get(0)).getResultMappings();
            for (ResultMapping resultMap : resultMappings) {
                propertyColumn.put(resultMap.getProperty(), resultMap.getColumn());
            }
        }
        StringBuilder buffer = new StringBuilder("select * from (").append(sql).append(") temp_order order by ");
        for (Order order : orders) {
            if (order == null) continue;
            if (propertyColumn != null && propertyColumn.containsKey(order.getProperty())) {
                order.setProperty((String)propertyColumn.get(order.getProperty()));
            }
            buffer.append(order.toString()).append(", ");
        }
        buffer.delete(buffer.length() - 2, buffer.length());
        return buffer.toString();
    }
}

