/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis.paginator.dialect;

import ins.framework.mybatis.PageParam;
import ins.framework.mybatis.paginator.dialect.Dialect;
import java.util.Locale;
import org.apache.ibatis.mapping.MappedStatement;

public class SQLServerDialect
extends Dialect {
    public SQLServerDialect(MappedStatement mappedStatement, Object parameterObject, PageParam pageParam) {
        super(mappedStatement, parameterObject, pageParam);
    }

    @Override
    protected String getLimitString(String sql, String offsetName, int offset, String limitName, int limit) {
        StringBuilder pagingBuilder = new StringBuilder();
        String orderby = SQLServerDialect.getOrderByPart(sql);
        String distinctStr = "";
        String loweredString = sql.toLowerCase(Locale.US);
        String sqlPartString = sql;
        if (loweredString.trim().startsWith("select")) {
            int index = 6;
            if (loweredString.startsWith("select distinct")) {
                distinctStr = "DISTINCT ";
                index = 15;
            }
            sqlPartString = sqlPartString.substring(index);
        }
        pagingBuilder.append(sqlPartString);
        if (orderby == null || orderby.length() == 0) {
            orderby = "ORDER BY CURRENT_TIMESTAMP";
        }
        StringBuilder result = new StringBuilder();
        result.append("WITH query AS (SELECT ").append(distinctStr).append("TOP 100 PERCENT ").append(" ROW_NUMBER() OVER (").append(orderby).append(") as __row_number__, ").append((CharSequence)pagingBuilder).append(") SELECT * FROM query WHERE __row_number__ > ? AND __row_number__ <= ?").append(" ORDER BY __row_number__");
        this.setPageParameter(offsetName, offset, Integer.class);
        this.setPageParameter("__offsetEnd", offset + limit, Integer.class);
        return result.toString();
    }

    static String getOrderByPart(String sql) {
        String loweredString = sql.toLowerCase(Locale.US);
        int orderByIndex = loweredString.indexOf("order by");
        if (orderByIndex != -1) {
            return sql.substring(orderByIndex);
        }
        return "";
    }
}

