/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mybatis.util;

import ins.framework.mybatis.paginator.dialect.Dialect;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class SQLHelper {
    private static final Logger log = LoggerFactory.getLogger(SQLHelper.class);

    private SQLHelper() {
    }

    public static int getCount(MappedStatement mappedStatement, Transaction transaction, Object parameterObject, BoundSql boundSql, Dialect dialect) throws SQLException {
        String countSql = dialect.getCountSQL();
        log.debug("Total count SQL [{}] ", (Object)countSql);
        log.debug("Total count Parameters: {} ", parameterObject);
        Connection connection = transaction.getConnection();
        int count = 0;
        try (PreparedStatement countStmt = connection.prepareStatement(countSql);){
            DefaultParameterHandler handler = new DefaultParameterHandler(mappedStatement, parameterObject, boundSql);
            handler.setParameters(countStmt);
            try (ResultSet rs = countStmt.executeQuery();){
                if (rs.next()) {
                    count = rs.getInt(1);
                }
            }
        }
        log.debug("Total count: {}", (Object)count);
        return count;
    }

    public static String removeOrders(String sql) {
        Assert.hasText((String)sql, (String)"sql must have value");
        Pattern p = Pattern.compile("order\\s*by[\\w|\\W|\\s|\\S]*", 2);
        Matcher m = p.matcher(sql);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static boolean isIncludeDistinct(String sql) {
        String hqlLowerCase = sql.toLowerCase(Locale.US);
        hqlLowerCase = hqlLowerCase.replace(" ", "");
        return hqlLowerCase.startsWith("selectdistinct");
    }
}

