/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.office;

import ins.framework.office.template.excel.ETE;
import ins.framework.office.util.LazyExcelList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;

public class Excels {
    private Excels() {
    }

    public static void create(File targetFile, File templateFile, Map<String, Object> datas) {
        File tempTemplateFile = null;
        try {
            tempTemplateFile = File.createTempFile("temp", ".xls");
            System.out.println("Temp file is " + tempTemplateFile.getAbsolutePath());
            FileUtils.copyFile((File)templateFile, (File)tempTemplateFile);
            ETE ete = ETE.createETE(tempTemplateFile);
            ete.execute(targetFile, datas);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        finally {
            if (tempTemplateFile != null) {
                tempTemplateFile.delete();
            }
        }
    }

    public static List<Object[]> readExcel(File file) {
        return new LazyExcelList(file, -1, "");
    }

    public static List<Object[]> readExcel(File file, String password) {
        return new LazyExcelList(file, -1, password);
    }

    public static List<Object[]> readExcel(File file, int sheetIndex) {
        return new LazyExcelList(file, sheetIndex, null);
    }

    public static List<Object[]> readExcel(File file, int sheetIndex, String password) {
        return new LazyExcelList(file, sheetIndex, password);
    }

    public static List<Object[]> readExcel(InputStream inputStream) {
        return new LazyExcelList(inputStream, -1, "");
    }

    public static List<Object[]> readExcel(InputStream inputStream, String password) {
        return new LazyExcelList(inputStream, -1, password);
    }

    public static List<Object[]> readExcel(InputStream inputStream, int sheetIndex) {
        return new LazyExcelList(inputStream, sheetIndex, null);
    }

    public static List<Object[]> readExcel(InputStream inputStream, int sheetIndex, String password) {
        return new LazyExcelList(inputStream, sheetIndex, password);
    }
}

