/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.office.io.excel.model.impl.jxl;

import ins.framework.office.io.excel.model.Sheet;
import ins.framework.office.io.excel.model.Workbook;
import ins.framework.office.io.excel.model.impl.jxl.JxlSheet;
import ins.framework.office.util.Lang;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JxlWorkBook
extends Workbook {
    byte[] datas;
    Log log = LogFactory.getLog(JxlWorkBook.class);
    WritableWorkbook wwb;

    public JxlWorkBook(File excelFile) {
        try {
            this.datas = FileUtils.readFileToByteArray((File)excelFile);
            this.wwb = jxl.Workbook.createWorkbook((File)excelFile, (jxl.Workbook)jxl.Workbook.getWorkbook((InputStream)new ByteArrayInputStream(this.datas)));
        }
        catch (Exception e) {
            this.log.error((Object)"\u65e0\u6cd5\u6839\u636e\u6307\u5b9a\u7684\u6587\u4ef6\u5bf9\u8c61\u89e3\u6790\u4e3a\u53ef\u7f16\u8f91\u5de5\u4f5c\u8868", (Throwable)e);
            Lang.throwException(e);
        }
    }

    public JxlWorkBook(File excelFile, InputStream is) {
        try {
            this.datas = IOUtils.toByteArray((InputStream)is);
            this.wwb = jxl.Workbook.createWorkbook((File)excelFile, (jxl.Workbook)jxl.Workbook.getWorkbook((InputStream)new ByteArrayInputStream(this.datas)));
        }
        catch (Exception e) {
            this.log.error((Object)"\u65e0\u6cd5\u6839\u636e\u6307\u5b9a\u7684\u6587\u4ef6\u5bf9\u8c61\u89e3\u6790\u4e3a\u53ef\u7f16\u8f91\u5de5\u4f5c\u8868", (Throwable)e);
            Lang.throwException(e);
        }
    }

    public JxlWorkBook(OutputStream os, InputStream is) {
        try {
            this.datas = IOUtils.toByteArray((InputStream)is);
            this.init(os, new ByteArrayInputStream(this.datas));
        }
        catch (Exception e) {
            this.log.error((Object)"\u65e0\u6cd5\u6839\u636e\u6307\u5b9a\u7684\u8f93\u5165\u8f93\u51fa\u6d41\u89e3\u6790\u4e3a\u53ef\u7f16\u8f91\u5de5\u4f5c\u8868", (Throwable)e);
        }
    }

    void init(OutputStream os, InputStream is) {
        try {
            this.wwb = jxl.Workbook.createWorkbook((OutputStream)os, (jxl.Workbook)jxl.Workbook.getWorkbook((InputStream)is));
        }
        catch (Exception e) {
            this.log.error((Object)"\u65e0\u6cd5\u6839\u636e\u6307\u5b9a\u7684\u8f93\u5165\u8f93\u51fa\u6d41\u89e3\u6790\u4e3a\u53ef\u7f16\u8f91\u5de5\u4f5c\u8868", (Throwable)e);
        }
    }

    @Override
    public Sheet[] getSheets() {
        WritableSheet[] sourceSheets = this.wwb.getSheets();
        ArrayList<JxlSheet> li = new ArrayList<JxlSheet>();
        for (WritableSheet ws : sourceSheets) {
            li.add(new JxlSheet(ws));
        }
        return li.toArray(new Sheet[0]);
    }

    @Override
    public Sheet getSheet(String sheetName) {
        WritableSheet ws = this.wwb.getSheet(sheetName);
        return new JxlSheet(ws);
    }

    @Override
    public Sheet getSheet(Integer sheetIndex) {
        WritableSheet ws = this.wwb.getSheet(sheetIndex.intValue());
        return new JxlSheet(ws);
    }

    @Override
    public Sheet createSheet(String sheetName, int sheetIndex) {
        WritableSheet ws = this.wwb.createSheet(sheetName, sheetIndex);
        return new JxlSheet(ws);
    }

    @Override
    public Sheet importSheet(String sheetName, int sheetIndex, Sheet sourceSheet) {
        WritableSheet ws = this.wwb.importSheet(sheetName, sheetIndex, (jxl.Sheet)((JxlSheet)sourceSheet).sheet);
        return new JxlSheet(ws);
    }

    @Override
    public Workbook copyTo(File file) {
        try {
            file.getParentFile().mkdirs();
            return new JxlWorkBook(file, (InputStream)new ByteArrayInputStream(this.datas));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Workbook copyTo(OutputStream os) {
        try {
            return new JxlWorkBook(os, (InputStream)new ByteArrayInputStream(this.datas));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.wwb.write();
            this.wwb.close();
        }
        catch (WriteException e) {
            Lang.throwException((Object)e);
        }
        catch (IOException e) {
            Lang.throwException(e);
        }
    }
}

