/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.office.template.excel.antlr;

import ins.framework.office.io.excel.model.Cell;
import ins.framework.office.io.excel.model.Sheet;
import ins.framework.office.template.excel.antlr.ETLLexer;
import ins.framework.office.template.excel.antlr.ETLParser;
import ins.framework.office.template.excel.antlr.Escapes;
import ins.framework.office.template.excel.antlr.model.CellMeta;
import ins.framework.office.template.excel.antlr.model.ProgNode;
import ins.framework.office.util.StackTreeMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jxl.write.Label;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.BaseTree;
import org.antlr.runtime.tree.CommonErrorNode;
import org.antlr.runtime.tree.CommonTree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SheetExecutor {
    static Log log = LogFactory.getLog(SheetExecutor.class);
    static ThreadLocal<Sheet> sheetTL = new ThreadLocal();
    static ThreadLocal<StackTreeMap<Integer, Cell>> cellsTL = new ThreadLocal();
    StackTreeMap<Integer, Cell> sourceCells;
    private String el;
    Sheet sourceSheet;
    ProgNode pn = null;
    List<CommonErrorNode> errorNodes = new ArrayList<CommonErrorNode>();

    public SheetExecutor(Sheet sheet) {
        this.sourceSheet = sheet;
        this.compile();
    }

    private void fixSheet(Sheet sheet) {
        Pattern p = Pattern.compile("\\<%.*?\\%>");
        for (int i = 0; i < sheet.getRows(); ++i) {
            Cell[] cs = sheet.getRow(i);
            for (int j = 0; j < cs.length; ++j) {
                if (!(cs[j].getSource() instanceof Label)) continue;
                Cell c = cs[j];
                String s = c.getContents();
                StringBuffer sb = new StringBuffer();
                Matcher m = p.matcher(s);
                sb = new StringBuffer();
                while (m.find()) {
                    m.appendReplacement(sb, "");
                }
                m.appendTail(sb);
                c.setValue(Escapes.from(sb.toString()));
            }
        }
    }

    private String getBlank(int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public void compile() {
        try {
            this.sourceCells = new StackTreeMap();
            StringBuilder sb = new StringBuilder();
            sb.append("%>");
            for (int i = 0; i < this.sourceSheet.getRows(); ++i) {
                Cell[] cs = this.sourceSheet.getRow(i);
                for (int j = 0; j < cs.length; ++j) {
                    if (!(cs[j].getSource() instanceof Label)) continue;
                    String value = cs[j].getContents();
                    sb.append(value);
                    this.sourceCells.put(sb.length(), cs[j]);
                }
            }
            sb.append("<%");
            this.el = sb.toString();
            log.debug((Object)("el:" + this.el));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.errorNodes.clear();
        try {
            this.getCells().putAll(this.sourceCells);
            ANTLRStringStream in = new ANTLRStringStream(this.el);
            ETLLexer lex = new ETLLexer((CharStream)in);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
            ETLParser g = new ETLParser((TokenStream)tokens);
            this.pn = new ProgNode(this, (BaseTree)g.prog().getTree(), null);
            this.handlerErrorNodes();
            this.getCells().clear();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void handlerErrorNodes() {
        if (!this.errorNodes.isEmpty()) {
            for (CommonErrorNode e : this.errorNodes) {
                Cell cell = this.getCell((CommonToken)e.start).getCell();
                log.error((Object)("\u7f16\u8bd1\u65f6\u5728\u5355\u5143\u683c\uff1a" + cell + "\u53d1\u73b0\u5f02\u5e38\u8282\u70b9\uff1a" + e));
            }
            CommonErrorNode e = this.errorNodes.get(0);
            Cell cell = this.getCell((CommonToken)e.start).getCell();
            throw new RuntimeException("\u7f16\u8bd1\u65f6\u5728\u5355\u5143\u683c\uff1a" + cell + "\u53d1\u73b0\u5f02\u5e38\u8282\u70b9\uff1a" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Sheet sheet, Map<String, Object> datas) {
        try {
            if (this.pn == null) {
                this.compile();
            }
            sheetTL.set(sheet);
            this.push();
            try {
                StackTreeMap<Integer, Cell> cells = this.getCells();
                for (Integer k : this.sourceCells.keySet()) {
                    Cell cell = this.sourceCells.get(k);
                    cell = sheet.getCell(cell.getRow(), cell.getColumn());
                    cells.put(k, cell);
                }
                this.pn.addData(datas);
                this.pn.execute();
                this.fixSheet(sheet);
            }
            finally {
                this.pop();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private StackTreeMap<Integer, Cell> getCells() {
        StackTreeMap<Integer, Cell> cells = cellsTL.get();
        if (cells == null) {
            cells = new StackTreeMap();
            cellsTL.set(cells);
        }
        return cells;
    }

    public void execute(Map<String, Object> datas) {
        this.execute(this.sourceSheet, datas);
    }

    public CellMeta getCell(BaseTree tree) {
        if (tree == null) {
            return null;
        }
        CellMeta cellMeta = null;
        if (tree instanceof CommonTree) {
            cellMeta = new CellMeta();
            CommonTree commonTree = (CommonTree)tree;
            CommonToken commonToken = (CommonToken)commonTree.getToken();
            cellMeta = this.getCell(commonToken);
        }
        return cellMeta;
    }

    public CellMeta getCell(CommonToken commonToken) {
        if (commonToken == null) {
            return null;
        }
        CellMeta cellMeta = null;
        cellMeta = new CellMeta();
        Cell cell = null;
        for (Integer index : this.getCells().keySet()) {
            if (index <= commonToken.getStartIndex()) continue;
            cell = this.getCells().get(index);
            cellMeta.setCell(cell);
            cellMeta.setStartIndex(commonToken.getStartIndex() + cell.getContents().length() - index);
            cellMeta.setEndIndex(commonToken.getStopIndex() + cell.getContents().length() - index);
            break;
        }
        if (cellMeta != null) {
            if (cellMeta.getStartIndex() < 0 || cellMeta.getEndIndex() < 0) {
                cellMeta = null;
            } else if (cellMeta.getEndIndex() > cellMeta.getStartIndex()) {
                String s = cellMeta.getCell().getContents();
                s = s.substring(0, cellMeta.getStartIndex()) + this.getBlank(cellMeta.getEndIndex() - cellMeta.getStartIndex() + 1) + s.substring(cellMeta.getEndIndex() + 1);
                cellMeta.getCell().setValue(s);
            }
        }
        return cellMeta;
    }

    public void push() {
        cellsTL.set(new StackTreeMap<Integer, Cell>(this.getCells()));
    }

    public void pop() {
        cellsTL.set((StackTreeMap)this.getCells().getParent());
    }

    public void copyRows(int begin, int d) {
        this.getSheet().copyRowsTo(begin, begin + d - 1, begin + d);
        for (Integer k : this.getCells().keySet()) {
            Cell c = this.getCells().get(k);
            if (c.getRow() < begin || c.getRow() > begin + d) continue;
            c = this.getSheet().getCell(c.getRow() + d, c.getColumn());
            this.getCells().put(k, c);
        }
    }

    Sheet getSheet() {
        return sheetTL.get();
    }

    public void deleteRows(int begin, int d) {
        for (int i = 0; i < d; ++i) {
            this.getSheet().removeRow(begin);
        }
    }

    public void addErrorNode(CommonErrorNode errorNode) {
        this.errorNodes.add(errorNode);
    }
}

