/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.office.template.excel.antlr.model;

import ins.framework.office.io.excel.model.Cell;
import ins.framework.office.template.excel.antlr.SheetExecutor;
import ins.framework.office.template.excel.antlr.model.CellMeta;
import ins.framework.office.template.excel.antlr.model.ElNode;
import ins.framework.office.template.excel.antlr.model.ForNode;
import ins.framework.office.template.excel.antlr.model.IDNode;
import ins.framework.office.template.excel.antlr.model.IFNode;
import ins.framework.office.template.excel.antlr.model.ProgNode;
import ins.framework.office.util.StackTreeMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.antlr.runtime.tree.BaseTree;
import org.antlr.runtime.tree.CommonErrorNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ETLNode {
    Log log = LogFactory.getLog(this.getClass());
    StackTreeMap<String, Object> data;
    SheetExecutor sheetExecutor;
    BaseTree current;
    ETLNode parent;
    List<ETLNode> childs = new ArrayList<ETLNode>();
    BaseTree startCell;
    BaseTree stopCell;

    public ETLNode(SheetExecutor sheetExecutor, BaseTree current, ETLNode parent) {
        this.sheetExecutor = sheetExecutor;
        this.parent = parent;
        this.current = current;
        this.data = parent != null ? new StackTreeMap<String, Object>(parent.data) : new StackTreeMap();
        this.handlerErrorNode();
        this.parseChildren();
        this.initChildren();
    }

    private void handlerErrorNode() {
        List childTrees;
        if (this.current instanceof CommonErrorNode) {
            this.sheetExecutor.addErrorNode((CommonErrorNode)this.current);
        }
        if ((childTrees = this.current.getChildren()) != null) {
            for (BaseTree childTree : childTrees) {
                if (!(childTree instanceof CommonErrorNode)) continue;
                this.sheetExecutor.addErrorNode((CommonErrorNode)childTree);
            }
        }
    }

    private void initChildren() {
        if (this.childs.isEmpty()) {
            this.stopCell = this.startCell = this.current;
            if (this.startCell == null) {
                throw new RuntimeException("\u8bed\u6cd5\u9519\u8bef\uff0c\u865a\u62df\u8282\u70b9\u5fc5\u987b\u5305\u542b\u5b50\u8282\u70b9");
            }
        } else {
            TreeSet<BaseTree> set = new TreeSet<BaseTree>(new Comparator<BaseTree>(){

                @Override
                public int compare(BaseTree o1, BaseTree o2) {
                    CellMeta cell1 = ETLNode.this.sheetExecutor.getCell(o1);
                    CellMeta cell2 = ETLNode.this.sheetExecutor.getCell(o2);
                    return cell1.getCell().getRow() - cell2.getCell().getRow();
                }
            });
            if (this.sheetExecutor.getCell(this.current) != null) {
                set.add(this.current);
            }
            for (ETLNode n : this.childs) {
                if (this.sheetExecutor.getCell(n.startCell) != null) {
                    set.add(n.startCell);
                }
                if (this.sheetExecutor.getCell(n.stopCell) == null) continue;
                set.add(n.stopCell);
            }
            if (!set.isEmpty()) {
                this.startCell = set.first();
                this.stopCell = set.last();
            }
        }
    }

    public void addData(Map<String, Object> data) {
        if (data != null) {
            this.data.putAll(data);
        }
    }

    public void addData(String k, Object v) {
        this.data.put(k, v);
    }

    protected void parseChildren() {
        List childTrees = this.current.getChildren();
        if (childTrees != null) {
            for (BaseTree childTree : childTrees) {
                if (childTree.getType() == 43) {
                    this.childs.add(new ProgNode(this.sheetExecutor, childTree, this));
                    continue;
                }
                if (childTree.getType() == 9) {
                    this.childs.add(new ElNode(this.sheetExecutor, childTree, this));
                    continue;
                }
                if (childTree.getType() == 13) {
                    this.childs.add(new ForNode(this.sheetExecutor, childTree, this));
                    continue;
                }
                if (childTree.getType() == 16) {
                    this.childs.add(new IFNode(this.sheetExecutor, childTree, this));
                    continue;
                }
                if (childTree.getType() != 15) continue;
                this.childs.add(new IDNode(this.sheetExecutor, childTree, this));
            }
        }
    }

    public String getText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.current.getText());
        for (ETLNode c : this.childs) {
            sb.append(c.getText());
        }
        return sb.toString();
    }

    public Object execute() {
        for (ETLNode n : this.childs) {
            n.execute();
        }
        return null;
    }

    Cell getCurrentCell() {
        CellMeta c = this.sheetExecutor.getCell(this.startCell);
        if (c != null) {
            return c.cell;
        }
        return null;
    }
}

