/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.poi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XlsxParser {
    private static final Logger log = LoggerFactory.getLogger(XlsxParser.class);
    private int minColumns = -1;
    private int sheetIndex = -1;
    private int titleRow;
    private String sheetName = "Sheet1";

    public int getMinColumns() {
        return this.minColumns;
    }

    public void setMinColumns(int minColumns) {
        this.minColumns = minColumns;
    }

    public int getTitleRow() {
        return this.titleRow;
    }

    public void setTitleRow(int titleRow) {
        this.titleRow = titleRow;
    }

    public void processSheet(StylesTable styles, ReadOnlySharedStringsTable strings, InputStream sheetInputStream) throws IOException, ParserConfigurationException, SAXException {
        InputSource sheetSource = new InputSource(sheetInputStream);
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        saxFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        SAXParser saxParser = saxFactory.newSAXParser();
        XMLReader sheetParser = saxParser.getXMLReader();
        MyXSSFSheetHandler handler = new MyXSSFSheetHandler(this, styles, strings, this.minColumns);
        sheetParser.setContentHandler(handler);
        sheetParser.parse(sheetSource);
    }

    public void process(String path) throws IOException, SAXException, OpenXML4JException, ParserConfigurationException {
        OPCPackage xlsxPackage = OPCPackage.open((String)path, (PackageAccess)PackageAccess.READ);
        this.realProcess(xlsxPackage);
    }

    public void process(InputStream in) throws IOException, SAXException, OpenXML4JException, ParserConfigurationException {
        OPCPackage xlsxPackage = OPCPackage.open((InputStream)in);
        this.realProcess(xlsxPackage);
        in.close();
    }

    public void process(File file) throws IOException, SAXException, OpenXML4JException, ParserConfigurationException {
        OPCPackage xlsxPackage = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ);
        this.realProcess(xlsxPackage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realProcess(OPCPackage pkg) throws IOException, SAXException, OpenXML4JException, ParserConfigurationException {
        try {
            ReadOnlySharedStringsTable strings = new ReadOnlySharedStringsTable(pkg);
            XSSFReader xssfReader = new XSSFReader(pkg);
            StylesTable styles = xssfReader.getStylesTable();
            XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
            int index = 0;
            while (iter.hasNext()) {
                InputStream stream = iter.next();
                this.sheetIndex = index++;
                this.sheetName = iter.getSheetName();
                this.processSheet(styles, strings, stream);
                stream.close();
            }
        }
        finally {
            pkg.close();
        }
    }

    public void processOneSheet(String path, int sheetIndex) throws IOException, ParserConfigurationException, SAXException, OpenXML4JException {
        OPCPackage pkg = OPCPackage.open((String)path, (PackageAccess)PackageAccess.READ);
        this.realProcessOneSheet(pkg, sheetIndex);
    }

    public void processOneSheet(InputStream in, int sheetIndex) throws IOException, ParserConfigurationException, SAXException, OpenXML4JException {
        OPCPackage pkg = OPCPackage.open((InputStream)in);
        this.realProcessOneSheet(pkg, sheetIndex);
    }

    public void processOneSheet(File file, int sheetIndex) throws IOException, SAXException, OpenXML4JException, ParserConfigurationException {
        OPCPackage xlsxPackage = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ);
        this.realProcessOneSheet(xlsxPackage, sheetIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realProcessOneSheet(OPCPackage pkg, int sheetId) throws IOException, ParserConfigurationException, SAXException, OpenXML4JException {
        try {
            ReadOnlySharedStringsTable strings = new ReadOnlySharedStringsTable(pkg);
            XSSFReader xssfReader = new XSSFReader(pkg);
            StylesTable styles = xssfReader.getStylesTable();
            XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
            int index = 0;
            while (iter.hasNext()) {
                InputStream stream = iter.next();
                this.sheetIndex = index++;
                this.sheetName = iter.getSheetName();
                if (this.sheetIndex == sheetId) {
                    this.processSheet(styles, strings, stream);
                    stream.close();
                    return;
                }
                stream.close();
            }
        }
        finally {
            pkg.close();
        }
    }

    public void optRows(int sheetIndex, String sheetName, int curRow, List<String> rowList) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("sheet").append(sheetIndex).append("(").append(sheetName).append(")@row").append(curRow).append(":");
        for (int i = 0; i < rowList.size(); ++i) {
            sb.append(rowList.get(i));
            if (i >= rowList.size() - 1) continue;
            sb.append(",");
        }
        log.info(sb.toString());
    }

    public void startDocument() throws SAXException {
        log.info("startDocument");
    }

    public void endDocument() throws SAXException {
        log.info("endDocument");
    }

    class MyXSSFSheetHandler
    extends DefaultHandler {
        private XlsxParser xlsxParser;
        private StylesTable stylesTable;
        private ReadOnlySharedStringsTable sharedStringsTable;
        private int minColumnCount;
        private boolean vIsOpen;
        private xssfDataType nextDataType;
        private short formatIndex;
        private String formatString;
        private final DataFormatter formatter;
        private int thisColumn = -1;
        private int lastColumnNumber = -1;
        private StringBuilder value;
        private List<String> rowList = new ArrayList<String>();
        private int curRow;

        public MyXSSFSheetHandler(XlsxParser xlsxParser, StylesTable styles, ReadOnlySharedStringsTable strings, int cols) {
            this.xlsxParser = xlsxParser;
            this.stylesTable = styles;
            this.sharedStringsTable = strings;
            this.minColumnCount = cols;
            this.value = new StringBuilder();
            this.nextDataType = xssfDataType.NUMBER;
            this.formatter = new DataFormatter();
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if ("inlineStr".equals(name) || "v".equals(name)) {
                this.vIsOpen = true;
                this.value.setLength(0);
            } else if ("c".equals(name)) {
                String r = attributes.getValue("r");
                int firstDigit = -1;
                for (int c = 0; c < r.length(); ++c) {
                    if (!Character.isDigit(r.charAt(c))) continue;
                    firstDigit = c;
                    break;
                }
                this.thisColumn = this.nameToColumn(r.substring(0, firstDigit));
                this.nextDataType = xssfDataType.NUMBER;
                this.formatIndex = (short)-1;
                this.formatString = null;
                String cellType = attributes.getValue("t");
                String cellStyleStr = attributes.getValue("s");
                if ("b".equals(cellType)) {
                    this.nextDataType = xssfDataType.BOOL;
                } else if ("e".equals(cellType)) {
                    this.nextDataType = xssfDataType.ERROR;
                } else if ("inlineStr".equals(cellType)) {
                    this.nextDataType = xssfDataType.INLINESTR;
                } else if ("s".equals(cellType)) {
                    this.nextDataType = xssfDataType.SSTINDEX;
                } else if ("str".equals(cellType)) {
                    this.nextDataType = xssfDataType.FORMULA;
                } else if (cellStyleStr != null) {
                    int styleIndex = Integer.parseInt(cellStyleStr);
                    XSSFCellStyle style = this.stylesTable.getStyleAt(styleIndex);
                    this.formatIndex = style.getDataFormat();
                    this.formatString = style.getDataFormatString();
                    if (this.formatString == null) {
                        this.formatString = BuiltinFormats.getBuiltinFormat((int)this.formatIndex);
                    }
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            String thisStr = null;
            if ("v".equals(name)) {
                switch (this.nextDataType) {
                    case BOOL: {
                        char first = this.value.charAt(0);
                        if (first == '0') {
                            thisStr = "FALSE";
                            break;
                        }
                        thisStr = "TRUE";
                        break;
                    }
                    case ERROR: {
                        thisStr = "\"ERROR:" + this.value.toString() + '\"';
                        break;
                    }
                    case FORMULA: {
                        thisStr = '\"' + this.value.toString() + '\"';
                        break;
                    }
                    case INLINESTR: {
                        XSSFRichTextString rtsi = new XSSFRichTextString(this.value.toString());
                        thisStr = '\"' + rtsi.toString() + '\"';
                        break;
                    }
                    case SSTINDEX: {
                        String sstIndex = this.value.toString();
                        try {
                            int idx = Integer.parseInt(sstIndex);
                            XSSFRichTextString rtss = new XSSFRichTextString(this.sharedStringsTable.getEntryAt(idx));
                            thisStr = rtss.toString();
                        }
                        catch (NumberFormatException ex) {
                            log.warn("{}", (Throwable)ex);
                        }
                        break;
                    }
                    case NUMBER: {
                        String n = this.value.toString();
                        if (this.formatString != null) {
                            thisStr = this.formatter.formatRawCellContents(Double.parseDouble(n), (int)this.formatIndex, this.formatString);
                            break;
                        }
                        thisStr = n;
                        break;
                    }
                    default: {
                        thisStr = "(TODO: Unexpected type: " + (Object)((Object)this.nextDataType) + ")";
                    }
                }
                if (this.lastColumnNumber == -1) {
                    this.lastColumnNumber = 0;
                }
                for (int i = this.lastColumnNumber + 1; i < this.thisColumn; ++i) {
                    this.rowList.add("");
                }
                this.rowList.add(thisStr);
                if (this.thisColumn > -1) {
                    this.lastColumnNumber = this.thisColumn;
                }
            } else if ("row".equals(name)) {
                if (this.minColumnCount < this.rowList.size()) {
                    this.minColumnCount = this.rowList.size();
                }
                if (this.lastColumnNumber == -1) {
                    this.lastColumnNumber = 0;
                }
                for (int i = this.lastColumnNumber + 1; i < this.minColumnCount; ++i) {
                    this.rowList.add("");
                }
                try {
                    if (this.curRow > XlsxParser.this.titleRow - 1) {
                        this.xlsxParser.optRows(XlsxParser.this.sheetIndex, XlsxParser.this.sheetName, this.curRow, this.rowList);
                    }
                }
                catch (Exception e) {
                    log.warn("{}", (Throwable)e);
                }
                this.rowList.clear();
                this.lastColumnNumber = -1;
                ++this.curRow;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.vIsOpen) {
                this.value.append(ch, start, length);
            }
        }

        private int nameToColumn(String name) {
            int column = -1;
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                column = (column + 1) * 26 + c - 65;
            }
            return column;
        }

        @Override
        public void startDocument() throws SAXException {
            this.xlsxParser.startDocument();
        }

        @Override
        public void endDocument() throws SAXException {
            this.xlsxParser.endDocument();
        }
    }

    static enum xssfDataType {
        BOOL,
        ERROR,
        FORMULA,
        INLINESTR,
        SSTINDEX,
        NUMBER;

    }
}

