/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.log;

import ins.framework.log.TraceLogUtil;
import ins.framework.log.domain.TraceData;
import java.util.ArrayDeque;
import java.util.Deque;

public final class TraceLogHolder {
    private static final ThreadLocal<Deque<TraceData>> logHolder = new ThreadLocal();
    private static final ThreadLocal<Deque<String>> idHolder = new ThreadLocal();

    private TraceLogHolder() {
    }

    public static void start() {
        if (logHolder.get() == null) {
            logHolder.set(new ArrayDeque());
        }
        logHolder.get().clear();
        if (idHolder.get() == null) {
            idHolder.set(new ArrayDeque());
        }
        idHolder.get().clear();
    }

    public static void push(TraceData data) {
        if (logHolder.get() == null) {
            logHolder.set(new ArrayDeque());
        }
        if (idHolder.get() == null) {
            idHolder.set(new ArrayDeque());
        }
        Deque<TraceData> dataStack = logHolder.get();
        Deque<String> idStack = idHolder.get();
        String parentId = data.getId();
        if (!idStack.isEmpty()) {
            parentId = idStack.peek();
        }
        data.setParentId(parentId);
        dataStack.push(data);
    }

    public static void pushId(TraceData data) {
        Deque<String> idStack = idHolder.get();
        idStack.push(data.getId());
    }

    public static String popId() {
        Deque<String> idStack = idHolder.get();
        return idStack.pop();
    }

    public static void clear() {
        logHolder.get().clear();
        idHolder.get().clear();
    }

    public static void log() {
        TraceLogUtil.log(logHolder.get());
    }
}

