/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.log;

import ins.framework.lang.Strings;
import ins.framework.log.domain.TraceData;
import ins.framework.log.domain.TraceLogDataType;
import java.lang.reflect.Method;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TraceLogUtil {
    private static final Logger log = LoggerFactory.getLogger((String)"TRACELOG");
    private static final int DEFAULT_MAX_SHOW_PARAM = 10;
    private static boolean enable;
    private static int maxShowParam;

    private TraceLogUtil() {
    }

    public static void setMaxShowParam(int maxShowParam) {
        TraceLogUtil.maxShowParam = maxShowParam;
    }

    public static void log(Deque<TraceData> stack) {
        ArrayList<TraceData> dataList = new ArrayList<TraceData>();
        ArrayList<String> timeStrList = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        TraceData root = stack.pollLast();
        long startTime = 0L;
        long useTime = root.getEndTime() - root.getBeginTime();
        timeStrList.add(startTime + "->" + (startTime + useTime) + "(" + useTime + "ms)");
        dataList.add(root);
        sb.append("[").append(root.getTagName() + "] [").append(useTime + "]");
        sb.append("\r\n");
        int deep = 0;
        HashMap<String, Integer> deepMap = new HashMap<String, Integer>();
        deepMap.put(root.getId(), 0);
        TraceData data = null;
        int maxUseTimeStrLen = 0;
        while (!stack.isEmpty()) {
            data = stack.pollLast();
            startTime = data.getBeginTime() - root.getBeginTime();
            useTime = data.getEndTime() - data.getBeginTime();
            String useTimeStr = "";
            if (data.getType() == TraceLogDataType.METHOD) {
                deep = (Integer)deepMap.get(data.getParentId()) + 1;
                deepMap.put(data.getId(), deep);
                useTimeStr = Strings.newString((char)' ', (int)(deep * 2)) + startTime + "->" + (startTime + useTime) + "(" + useTime + "ms)";
            } else if (data.getType() == TraceLogDataType.TAG) {
                deep = (Integer)deepMap.get(data.getParentId()) + 1;
                useTimeStr = Strings.newString((char)' ', (int)(deep * 2)) + startTime + "(AT)";
            } else {
                log.warn("Inner error,not support type {}", data.getType());
            }
            timeStrList.add(useTimeStr);
            dataList.add(data);
            if (maxUseTimeStrLen >= useTimeStr.length()) continue;
            maxUseTimeStrLen = useTimeStr.length();
        }
        for (int i = 0; i < timeStrList.size(); ++i) {
            String timeStr = (String)timeStrList.get(i);
            sb.append(timeStr);
            sb.append(Strings.newString((char)' ', (int)(maxUseTimeStrLen - timeStr.length() + 1)));
            sb.append((CharSequence)TraceLogUtil.convent2String((TraceData)dataList.get(i))).append("\r\n");
        }
        log.info("{}", (Object)sb);
    }

    private static StringBuilder convent2String(TraceData data) {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        sb.append(formatter.format(data.getBeginTime())).append(" ");
        if (data.getType() == TraceLogDataType.WEB) {
            sb.append(data.getTagName());
            sb.append(TraceLogUtil.parameterMapToString(data.getParameterMap()));
        } else if (data.getType() == TraceLogDataType.METHOD) {
            sb.append(TraceLogUtil.methodToString(data.getMethod(), data.getArguments()));
        } else if (data.getType() == TraceLogDataType.TAG) {
            sb.append(data.getTagName());
        } else {
            log.warn("Inner error,not support type {}", data.getType());
        }
        return sb;
    }

    public static boolean isEnable() {
        return enable;
    }

    public static void setEnable(boolean enable) {
        TraceLogUtil.enable = enable;
    }

    private static String getTypeName(Class<?> type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuilder sb = new StringBuilder();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        return type.getName();
    }

    private static CharSequence parameterMapToString(Map<String, String[]> parameterMap) {
        StringBuilder sb = new StringBuilder();
        sb.append(" parameterMap={");
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String key = entry.getKey();
            String[] values = entry.getValue();
            sb.append(key).append(":");
            if (values.length == 1) {
                sb.append(values[0]);
            } else if (values.length > 1) {
                sb.append("[");
                for (int i = 0; i < values.length - 1; ++i) {
                    String value = values[i];
                    sb.append(TraceLogUtil.valueToString(value)).append(",");
                }
                sb.append("\"").append(values[values.length - 1]).append("\"");
                sb.append("]");
            }
            sb.append(',');
        }
        int lastPos = sb.length() - 1;
        if (sb.charAt(lastPos) == ',') {
            sb.deleteCharAt(lastPos);
        }
        sb.append('}');
        return sb;
    }

    private static String methodToString(Method method, Object[] args) {
        try {
            int i;
            StringBuilder sb = new StringBuilder();
            sb.append(TraceLogUtil.getTypeName(method.getDeclaringClass())).append('.');
            sb.append(method.getName()).append('(');
            Class<?>[] params = method.getParameterTypes();
            for (i = 0; i < params.length; ++i) {
                sb.append(TraceLogUtil.getTypeName(params[i]));
                if (i >= params.length - 1) continue;
                sb.append(',');
            }
            sb.append(')');
            sb.append(" Args={");
            if (args != null) {
                for (i = 0; i < args.length; ++i) {
                    Object arg = args[i];
                    sb.append(TraceLogUtil.valueToString(arg));
                    if (i >= args.length - 1) continue;
                    sb.append(',');
                }
            }
            sb.append('}');
            return sb.toString();
        }
        catch (Exception e) {
            return Strings.concat((Object[])new Object[]{"<", e, ">"});
        }
    }

    private static String valueToString(Object arg) {
        try {
            StringBuilder sb = new StringBuilder();
            if (arg == null) {
                sb.append("null");
            } else if (arg instanceof String) {
                sb.append('\"').append(arg).append('\"');
            } else if (arg instanceof Date) {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                sb.append('\"').append(formatter.format(arg)).append('\"');
            } else if (arg.getClass().isPrimitive() || arg instanceof Number || arg instanceof Boolean) {
                sb.append(arg);
            } else if (arg.getClass().isArray()) {
                Object[] values = (Object[])arg;
                sb.append("[");
                if (values.length == 1) {
                    sb.append(values[0]);
                } else if (values.length > 1) {
                    int index;
                    for (index = 0; index < values.length - 1; ++index) {
                        Object value = values[index];
                        sb.append(TraceLogUtil.valueToString(value)).append(",");
                        if (index < maxShowParam) continue;
                        sb.append("...").append(",");
                        break;
                    }
                    sb.append(values[index]);
                }
                sb.append("]");
            } else {
                sb.append(ToStringBuilder.reflectionToString((Object)arg));
            }
            return sb.toString();
        }
        catch (Exception e) {
            return Strings.concat((Object[])new Object[]{"<", e, ">"});
        }
    }

    static {
        maxShowParam = 10;
    }
}

