/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.log.domain;

import ins.framework.log.domain.TraceLogDataType;
import ins.framework.utils.Uuids;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public class TraceData {
    private String id;
    private String parentId;
    private Object[] arguments;
    private Method method;
    private long beginTime;
    private long endTime;
    private String tagName;
    private Enum<TraceLogDataType> type;
    private Map<String, String[]> parameterMap;

    public TraceData(String ... tag) {
        this.id = Uuids.longUuid();
        this.type = TraceLogDataType.TAG;
        this.tagName = StringUtils.join((Object[])tag);
        this.endTime = this.beginTime = System.currentTimeMillis();
    }

    public TraceData(HttpServletRequest req) {
        this.id = Uuids.longUuid();
        this.tagName = req.getRequestURI();
        this.type = TraceLogDataType.WEB;
        this.beginTime = System.currentTimeMillis();
        this.parameterMap = req.getParameterMap();
    }

    public TraceData(ProceedingJoinPoint pjp) {
        this.id = Uuids.shortUuid().replace("-", "");
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        this.type = TraceLogDataType.METHOD;
        this.beginTime = System.currentTimeMillis();
        this.method = signature.getMethod();
        this.arguments = pjp.getArgs();
    }

    public String getId() {
        return this.id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public Method getMethod() {
        return this.method;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public String getTagName() {
        return this.tagName;
    }

    public Enum<TraceLogDataType> getType() {
        return this.type;
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setBeginTime(long beginTime) {
        this.beginTime = beginTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public void setType(Enum<TraceLogDataType> type) {
        this.type = type;
    }

    public void setParameterMap(Map<String, String[]> parameterMap) {
        this.parameterMap = parameterMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TraceData)) {
            return false;
        }
        TraceData other = (TraceData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$parentId = this.getParentId();
        String other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getArguments(), other.getArguments())) {
            return false;
        }
        Method this$method = this.getMethod();
        Method other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
            return false;
        }
        if (this.getBeginTime() != other.getBeginTime()) {
            return false;
        }
        if (this.getEndTime() != other.getEndTime()) {
            return false;
        }
        String this$tagName = this.getTagName();
        String other$tagName = other.getTagName();
        if (this$tagName == null ? other$tagName != null : !this$tagName.equals(other$tagName)) {
            return false;
        }
        Enum<TraceLogDataType> this$type = this.getType();
        Enum<TraceLogDataType> other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Map<String, String[]> this$parameterMap = this.getParameterMap();
        Map<String, String[]> other$parameterMap = other.getParameterMap();
        return !(this$parameterMap == null ? other$parameterMap != null : !((Object)this$parameterMap).equals(other$parameterMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TraceData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getArguments());
        Method $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
        long $beginTime = this.getBeginTime();
        result = result * 59 + (int)($beginTime >>> 32 ^ $beginTime);
        long $endTime = this.getEndTime();
        result = result * 59 + (int)($endTime >>> 32 ^ $endTime);
        String $tagName = this.getTagName();
        result = result * 59 + ($tagName == null ? 43 : $tagName.hashCode());
        Enum<TraceLogDataType> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Map<String, String[]> $parameterMap = this.getParameterMap();
        result = result * 59 + ($parameterMap == null ? 43 : ((Object)$parameterMap).hashCode());
        return result;
    }

    public String toString() {
        return "TraceData(id=" + this.getId() + ", parentId=" + this.getParentId() + ", arguments=" + Arrays.deepToString(this.getArguments()) + ", method=" + this.getMethod() + ", beginTime=" + this.getBeginTime() + ", endTime=" + this.getEndTime() + ", tagName=" + this.getTagName() + ", type=" + this.getType() + ", parameterMap=" + this.getParameterMap() + ")";
    }
}

