/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.utils.copier;

import ins.framework.utils.copier.FastCopier;
import ins.framework.utils.copier.FastCopierConverter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.beanutils.MethodUtils;

public class SimpleCopier {
    private static final Map<Class, Map<Class, FastCopier>> COPIERS_CASESENSITIVE_MAP = new WeakHashMap<Class, Map<Class, FastCopier>>();
    private static final Map<Class, Map<Class, FastCopier>> COPIERS_CASEINSENSITIVE_MAP = new WeakHashMap<Class, Map<Class, FastCopier>>();
    private Set<String> includes;
    private Set<String> excludes;
    private boolean caseSensitive = true;
    private boolean includeNull = true;
    private boolean includeEmpty = true;
    private boolean includePrimitiveZero = true;
    private boolean includePrimitiveFalse = true;
    private Object from;
    private List<Object> toList;

    public SimpleCopier includeNull() {
        this.includeNull = true;
        return this;
    }

    public SimpleCopier excludeNull() {
        this.includeNull = false;
        return this;
    }

    public SimpleCopier includeEmpty() {
        this.includeEmpty = true;
        return this;
    }

    public SimpleCopier excludeEmpty() {
        this.includeEmpty = false;
        return this;
    }

    public SimpleCopier includePrimitiveFalse() {
        this.includePrimitiveFalse = true;
        return this;
    }

    public SimpleCopier excludePrimitiveFalse() {
        this.includePrimitiveFalse = false;
        return this;
    }

    public SimpleCopier includePrimitiveZero() {
        this.includePrimitiveZero = true;
        return this;
    }

    public SimpleCopier excludePrimitiveZero() {
        this.includePrimitiveZero = false;
        return this;
    }

    public SimpleCopier caseSensitive() {
        this.caseSensitive = true;
        return this;
    }

    public SimpleCopier caseInsensitive() {
        this.caseSensitive = false;
        return this;
    }

    public SimpleCopier includes(String ... names) {
        for (String name : names) {
            if (name == null) continue;
            name = name.trim();
            if (this.includes == null) {
                this.includes = new HashSet<String>();
            }
            this.includes.add(name);
        }
        return this;
    }

    public SimpleCopier excludes(String ... names) {
        for (String name : names) {
            if (name == null) continue;
            name = name.trim();
            if (this.excludes == null) {
                this.excludes = new HashSet<String>();
            }
            this.excludes.add(name);
        }
        return this;
    }

    public SimpleCopier from(Object from) {
        this.from = from;
        this.done();
        return this;
    }

    public SimpleCopier to(Object ... tos) {
        this.toList = new ArrayList<Object>(tos.length);
        for (Object to : tos) {
            if (to == null) continue;
            this.toList.add(to);
        }
        this.done();
        return this;
    }

    public SimpleCopier clear() {
        this.from = null;
        this.toList = null;
        return this;
    }

    private void done() {
        if (this.from == null || this.toList == null || this.toList.isEmpty()) {
            return;
        }
        this.fastCopy();
    }

    private boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Map) {
            return ((Map)obj).isEmpty();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        return false;
    }

    private void fastCopy() {
        for (Object to : this.toList) {
            FastCopier cglibCopier;
            Map<Class, FastCopier> copierMap;
            if (to == null) continue;
            Class<?> fromClass = this.from.getClass();
            Class<?> toClass = to.getClass();
            Map<Class, FastCopier> map = copierMap = this.caseSensitive ? COPIERS_CASESENSITIVE_MAP.get(fromClass) : COPIERS_CASEINSENSITIVE_MAP.get(fromClass);
            if (copierMap == null) {
                copierMap = new HashMap<Class, FastCopier>();
                if (this.caseSensitive) {
                    COPIERS_CASESENSITIVE_MAP.put(fromClass, copierMap);
                } else {
                    COPIERS_CASEINSENSITIVE_MAP.put(fromClass, copierMap);
                }
            }
            if ((cglibCopier = copierMap.get(toClass)) == null) {
                cglibCopier = FastCopier.create(fromClass, toClass, true, this.caseSensitive);
                copierMap.put(toClass, cglibCopier);
            }
            cglibCopier.copy(this.from, to, new FastCopierConverter(){

                @Override
                public Object convert(Object fromValue, Object target, Class sourceClass, Class targetClass, Object context) {
                    if (!this.getWrapper(targetClass).isAssignableFrom(this.getWrapper(sourceClass))) {
                        return target;
                    }
                    if (sourceClass.equals(List.class)) {
                        return target;
                    }
                    if (SimpleCopier.this.includes != null && !SimpleCopier.this.includes.contains(context)) {
                        return target;
                    }
                    if (SimpleCopier.this.excludes != null && SimpleCopier.this.excludes.contains(context)) {
                        return target;
                    }
                    if (!SimpleCopier.this.includeNull && fromValue == null) {
                        return target;
                    }
                    if (!SimpleCopier.this.includeEmpty && fromValue != null && SimpleCopier.this.isEmpty(fromValue)) {
                        return target;
                    }
                    if (fromValue != null) {
                        if (!SimpleCopier.this.includePrimitiveFalse && sourceClass.equals(Boolean.TYPE) && SimpleCopier.valueEquals(fromValue, false)) {
                            return target;
                        }
                        if (!SimpleCopier.this.includePrimitiveZero && sourceClass.isPrimitive() && fromValue instanceof Number && SimpleCopier.valueEquals(fromValue, 0)) {
                            return target;
                        }
                    }
                    return fromValue;
                }

                private Class<?> getWrapper(Class<?> type) {
                    if (type.isPrimitive()) {
                        return MethodUtils.getPrimitiveWrapper(type);
                    }
                    return type;
                }
            });
        }
    }

    private static boolean valueEquals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        if (a instanceof Comparable && b instanceof Comparable) {
            return ((Comparable)a).compareTo((Comparable)b) != 0;
        }
        return false;
    }
}

