/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.utils;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Maps {
    private Maps() {
    }

    public static <K, V> Map<K, V> caseInsensitiveMap(final Map<K, V> source) {
        final HashMap<String, V> lowerCaseMap = new HashMap<String, V>();
        for (Map.Entry<K, V> entry : source.entrySet()) {
            K key = entry.getKey();
            if (key == null || !(key instanceof String)) continue;
            lowerCaseMap.put(Maps.toLowercase(key), source.get(key));
        }
        return new AbstractMap<K, V>(){

            @Override
            public Set<Map.Entry<K, V>> entrySet() {
                return source.entrySet();
            }

            @Override
            public boolean containsKey(Object key) {
                if (key != null && key instanceof String) {
                    return lowerCaseMap.containsKey(Maps.toLowercase(key));
                }
                return source.containsKey(key);
            }

            @Override
            public V get(Object key) {
                if (key != null && key instanceof String) {
                    return lowerCaseMap.get(Maps.toLowercase(key));
                }
                return source.get(key);
            }

            @Override
            public V put(K key, V value) {
                if (key != null && key instanceof String) {
                    String lowercaseKey = Maps.toLowercase(key);
                    source.put(key, value);
                    return lowerCaseMap.put(lowercaseKey, value);
                }
                return source.put(key, value);
            }
        };
    }

    private static String toLowercase(Object key) {
        return key.toString().toLowerCase();
    }
}

