/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.utils;

import java.util.UUID;
import org.apache.commons.codec.binary.Base64;

public class Uuids {
    private Uuids() {
    }

    public static String longUuid() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString().replace("-", "");
    }

    public static String shortUuid() {
        UUID uuid = UUID.randomUUID();
        return Uuids.compressedUUID(uuid);
    }

    private static String compressedUUID(UUID uuid) {
        byte[] byUuid = new byte[16];
        long least = uuid.getLeastSignificantBits();
        long most = uuid.getMostSignificantBits();
        Uuids.long2bytes(most, byUuid, 0);
        Uuids.long2bytes(least, byUuid, 8);
        return Base64.encodeBase64URLSafeString((byte[])byUuid);
    }

    private static void long2bytes(long value, byte[] bytes, int offset) {
        for (int i = 7; i > -1; --i) {
            bytes[offset++] = (byte)(value >> 8 * i & 0xFFL);
        }
    }

    public static String longUuid2short(String longUuid) {
        UUID uuid = UUID.fromString(longUuid);
        return Uuids.compressedUUID(uuid);
    }

    public static String shortUuid2long(String shortUuid) {
        if (shortUuid.length() != 22) {
            throw new IllegalArgumentException("Invalid uuid!");
        }
        byte[] byUuid = Base64.decodeBase64((String)(shortUuid + "=="));
        long most = Uuids.bytes2long(byUuid, 0);
        long least = Uuids.bytes2long(byUuid, 8);
        UUID uuid = new UUID(most, least);
        return uuid.toString();
    }

    private static long bytes2long(byte[] bytes, int offset) {
        long value = 0L;
        for (int i = 7; i > -1; --i) {
            value |= ((long)bytes[offset++] & 0xFFL) << 8 * i;
        }
        return value;
    }
}

