/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.utils.copier;

import ins.framework.utils.copier.FastCopierConverter;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import net.sf.cglib.asm.ClassVisitor;
import net.sf.cglib.asm.Type;
import net.sf.cglib.core.AbstractClassGenerator;
import net.sf.cglib.core.ClassEmitter;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.EmitUtils;
import net.sf.cglib.core.KeyFactory;
import net.sf.cglib.core.Local;
import net.sf.cglib.core.MethodInfo;
import net.sf.cglib.core.ReflectUtils;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;

public abstract class FastCopier {
    private static final BeanCopierKey KEY_FACTORY = (BeanCopierKey)KeyFactory.create(BeanCopierKey.class);
    private static final Type CONVERTER = TypeUtils.parseType((String)FastCopierConverter.class.getCanonicalName());
    private static final Type BEAN_COPIER = TypeUtils.parseType((String)FastCopier.class.getCanonicalName());
    private static final Signature COPY = new Signature("copy", Type.VOID_TYPE, new Type[]{Constants.TYPE_OBJECT, Constants.TYPE_OBJECT, CONVERTER});
    private static final Signature CONVERT = TypeUtils.parseSignature((String)"Object convert(Object, Object, Class, Class, Object)");

    public abstract void copy(Object var1, Object var2, FastCopierConverter var3);

    public static FastCopier create(Class<?> source, Class<?> target, boolean useConverter, boolean caseSensitive) {
        Generator gen = new Generator();
        gen.setSource(source);
        gen.setTarget(target);
        gen.setUseConverter(useConverter);
        gen.setCaseSensitive(caseSensitive);
        return gen.create();
    }

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source(FastCopier.class.getName());
        private Class source;
        private Class target;
        private boolean useConverter;
        private boolean caseSensitive;

        public Generator() {
            super(SOURCE);
        }

        public void setSource(Class source) {
            if (!Modifier.isPublic(source.getModifiers())) {
                this.setNamePrefix(source.getName());
            }
            this.source = source;
        }

        public void setTarget(Class target) {
            if (!Modifier.isPublic(target.getModifiers())) {
                this.setNamePrefix(target.getName());
            }
            this.target = target;
        }

        public void setUseConverter(boolean useConverter) {
            this.useConverter = useConverter;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        protected ClassLoader getDefaultClassLoader() {
            return this.source.getClassLoader();
        }

        public FastCopier create() {
            Object key = KEY_FACTORY.newInstance(this.source.getName(), this.target.getName(), this.useConverter, this.caseSensitive);
            return (FastCopier)super.create(key);
        }

        public void generateClass(ClassVisitor v) {
            Type sourceType = Type.getType((Class)this.source);
            Type targetType = Type.getType((Class)this.target);
            ClassEmitter ce = new ClassEmitter(v);
            ce.begin_class(46, 1, this.getClassName(), BEAN_COPIER, null, "<generated>");
            EmitUtils.null_constructor((ClassEmitter)ce);
            CodeEmitter e = ce.begin_method(1, COPY, null);
            PropertyDescriptor[] sourcePropertyDescriptors = this.getBeanProperties(this.source);
            PropertyDescriptor[] targetPropertyDescriptors = this.getBeanProperties(this.target);
            HashMap<String, PropertyDescriptor> targetPropertyDescriptorMap = new HashMap<String, PropertyDescriptor>();
            for (int i = 0; i < targetPropertyDescriptors.length; ++i) {
                PropertyDescriptor setter = targetPropertyDescriptors[i];
                String name = setter.getName();
                if ("class".equals(name) || setter.getPropertyType() == null || setter.getWriteMethod() == null || setter.getReadMethod() == null) continue;
                if (!this.caseSensitive) {
                    name = name.toLowerCase();
                }
                targetPropertyDescriptorMap.put(name, targetPropertyDescriptors[i]);
            }
            Local targetLocal = e.make_local();
            Local sourceLocal = e.make_local();
            if (this.useConverter) {
                e.load_arg(1);
                e.checkcast(targetType);
                e.store_local(targetLocal);
                e.load_arg(0);
                e.checkcast(sourceType);
                e.store_local(sourceLocal);
            } else {
                e.load_arg(1);
                e.checkcast(targetType);
                e.load_arg(0);
                e.checkcast(sourceType);
            }
            for (int i = 0; i < sourcePropertyDescriptors.length; ++i) {
                PropertyDescriptor targetPropertyDescriptor;
                PropertyDescriptor sourcePropertyDescriptor = sourcePropertyDescriptors[i];
                String name = sourcePropertyDescriptor.getName();
                if ("class".equals(name) || sourcePropertyDescriptor.getPropertyType() == null || sourcePropertyDescriptor.getReadMethod() == null) continue;
                if (!this.caseSensitive) {
                    name = name.toLowerCase();
                }
                if ((targetPropertyDescriptor = (PropertyDescriptor)targetPropertyDescriptorMap.get(name)) == null) continue;
                MethodInfo sourceRead = ReflectUtils.getMethodInfo((Member)sourcePropertyDescriptor.getReadMethod());
                MethodInfo targetRead = ReflectUtils.getMethodInfo((Member)targetPropertyDescriptor.getReadMethod());
                MethodInfo targetWrite = ReflectUtils.getMethodInfo((Member)targetPropertyDescriptor.getWriteMethod());
                if (this.useConverter) {
                    e.load_local(targetLocal);
                    e.load_arg(2);
                    e.load_local(sourceLocal);
                    e.invoke(sourceRead);
                    e.box(sourceRead.getSignature().getReturnType());
                    e.load_local(targetLocal);
                    e.invoke(targetRead);
                    e.box(targetRead.getSignature().getReturnType());
                    Type getterType = sourceRead.getSignature().getReturnType();
                    EmitUtils.load_class((CodeEmitter)e, (Type)getterType);
                    Type setterType = targetWrite.getSignature().getArgumentTypes()[0];
                    EmitUtils.load_class((CodeEmitter)e, (Type)setterType);
                    e.push(name);
                    e.invoke_interface(CONVERTER, CONVERT);
                    e.unbox_or_zero(setterType);
                    e.invoke(targetWrite);
                    continue;
                }
                if (!Generator.compatible(sourcePropertyDescriptor, targetPropertyDescriptor)) continue;
                e.dup2();
                e.invoke(sourceRead);
                e.invoke(targetWrite);
            }
            e.return_value();
            e.end_method();
            ce.end_class();
        }

        private PropertyDescriptor[] getBeanProperties(Class<?> type) {
            try {
                return Introspector.getBeanInfo(type).getPropertyDescriptors();
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e);
            }
        }

        private static boolean compatible(PropertyDescriptor getter, PropertyDescriptor setter) {
            return setter.getPropertyType().isAssignableFrom(getter.getPropertyType());
        }

        protected Object firstInstance(Class type) {
            return ReflectUtils.newInstance((Class)type);
        }

        protected Object nextInstance(Object instance) {
            return instance;
        }
    }

    static interface BeanCopierKey {
        public Object newInstance(String var1, String var2, boolean var3, boolean var4);
    }
}

