/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.web.support;

import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;

public class StringToDateConverter
implements Converter<String, Date> {
    private static Logger logger = LoggerFactory.getLogger(StringToDateConverter.class);
    private static final String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyy/MM/dd HH", "yyyy-MM-dd HH:mm:ss.SSS"};

    public Date convert(String str) {
        if (str == null || str.trim().equals("")) {
            return null;
        }
        try {
            return DateUtils.parseDate((String)str, (String[])parsePatterns);
        }
        catch (ParseException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

