/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.web;

import java.io.Serializable;
import java.util.Date;

public class ApiResponse<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int SUCCESS = 0;
    public static final int FAIL = -1;
    public static final int BUSY = -100;
    public static final String SUCCESS_TEXT = "Success";
    public static final String FAIL_TEXT = "Fail";
    public static final String BUSY_TEXT = "Busy";
    private long status;
    private String statusText;
    private String message;
    private Date timestamp = new Date();
    private T data;

    public ApiResponse() {
        this.status = 0L;
        this.message = this.statusText = SUCCESS_TEXT;
    }

    public ApiResponse(long status, String message, T data) {
        this.status = status;
        this.statusText = message;
        this.data = data;
        this.message = this.statusText;
    }

    public ApiResponse(T data) {
        if (data instanceof Exception) {
            this.status = -1L;
            this.statusText = ((Exception)data).getLocalizedMessage();
        } else {
            this.status = 0L;
            this.statusText = SUCCESS_TEXT;
            this.data = data;
        }
        this.message = this.statusText;
    }

    public long getStatus() {
        return this.status;
    }

    public void setStatus(long status) {
        this.status = status;
        this.statusText = status == 0L ? SUCCESS_TEXT : (status == -100L ? BUSY_TEXT : "");
    }

    public String getStatusText() {
        return this.statusText;
    }

    public void setStatusText(String message) {
        this.message = this.statusText = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.statusText = this.message = message;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public static <M> ApiResponse<M> ok() {
        return new ApiResponse();
    }

    public static <T> ApiResponse<T> ok(T data) {
        return new ApiResponse<T>(data);
    }

    public static <T> ApiResponse<T> fail(String message) {
        return new ApiResponse<Object>(-1L, message, null);
    }

    public static <T> ApiResponse<T> fail(String message, T data) {
        return new ApiResponse<T>(-1L, message, data);
    }
}

