/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.web.bind.method.annotation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerMapping;

public abstract class BaseMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    protected Map<String, String[]> getPrefixParameterMap(String namePrefix, NativeWebRequest request, boolean subPrefix) {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        Map<String, String> variables = this.getUriTemplateVariables(request);
        int namePrefixLength = namePrefix.length();
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!name.startsWith(namePrefix)) continue;
            if (subPrefix) {
                char ch = name.charAt(namePrefix.length());
                if (BaseMethodArgumentResolver.illegalChar(ch)) continue;
                result.put(name.substring(namePrefixLength + 1), new String[]{value});
                continue;
            }
            result.put(name, new String[]{value});
        }
        Iterator parameterNames = request.getParameterNames();
        while (parameterNames.hasNext()) {
            String name = (String)parameterNames.next();
            if (!name.startsWith(namePrefix)) continue;
            if (subPrefix) {
                char ch = name.charAt(namePrefix.length());
                if (BaseMethodArgumentResolver.illegalChar(ch)) continue;
                result.put(name.substring(namePrefixLength + 1), request.getParameterValues(name));
                continue;
            }
            result.put(name, request.getParameterValues(name));
        }
        return result;
    }

    private static boolean illegalChar(char ch) {
        return ch != '.' && ch != '_' && (ch < '0' || ch > '9');
    }

    protected final Map<String, String> getUriTemplateVariables(NativeWebRequest request) {
        Map<String, String> variables = (Map<String, String>)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE, 0);
        if (variables == null) {
            variables = Collections.emptyMap();
        }
        return variables;
    }
}

