/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.web.exception;

import ins.framework.exception.BusinessException;
import ins.framework.exception.DataVerifyException;
import ins.framework.exception.PermissionException;
import ins.framework.web.exception.CustomExceptionProcessor;
import ins.framework.web.i18n.LocaleMessageService;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorViewResolver;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

public class CustomizeErrorController
extends BasicErrorController {
    private static final String DATA_VERIFY_FAILED = "Data verify failed";
    @Resource
    private LocaleMessageService localeMessageService;
    @Autowired(required=false)
    private CustomExceptionProcessor customExceptionProcessor;

    public CustomizeErrorController(ErrorAttributes errorAttributes, ErrorProperties errorProperties, List<ErrorViewResolver> errorViewResolvers) {
        super(errorAttributes, errorProperties, errorViewResolvers);
    }

    @RequestMapping
    @ResponseBody
    public ResponseEntity<Map<String, Object>> error(HttpServletRequest request) {
        Map body = this.getErrorAttributes(request, false);
        HttpStatus status = this.getStatus(request);
        Throwable cause = (Throwable)request.getAttribute("javax.servlet.error.exception");
        if (cause != null && cause.getCause() != null) {
            if (this.customExceptionProcessor == null) {
                this.defaultProcess(cause.getCause(), body);
            } else {
                if (this.customExceptionProcessor.useDefault()) {
                    this.defaultProcess(cause.getCause(), body);
                }
                this.customExceptionProcessor.process(cause.getCause(), body);
            }
        }
        return new ResponseEntity((Object)body, status);
    }

    private void defaultProcess(Throwable cause, Map<String, Object> body) {
        if (cause == null) {
            return;
        }
        if (cause instanceof BusinessException) {
            BusinessException be = (BusinessException)cause;
            String msg = be.getMessageKey();
            if (be.isResource() && this.localeMessageService != null) {
                msg = this.localeMessageService.getMessage(be.getMessageKey(), null, be.getMessageKey());
            }
            body.put("message", msg);
        } else if (cause instanceof PermissionException) {
            PermissionException be = (PermissionException)cause;
            body.put("message", String.format("Can't access task %s", be.getTaskCode()));
        } else if (cause instanceof DataVerifyException) {
            body.put("message", DATA_VERIFY_FAILED);
        } else if (cause instanceof DuplicateKeyException) {
            body.put("message", "Duplicate entry");
        }
    }
}

