/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.web.util;

import ins.framework.web.ApiResponse;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordValidate {
    private static final Logger log = LoggerFactory.getLogger(PasswordValidate.class);
    private static final Pattern DIGIT3_PATTERN = Pattern.compile("\\d{3,}");
    private static final String BEGININDEX = "8";
    private static final String ENDINDEX = "20";
    private static final String COMMON_PASS = "picc";
    private static final int COMMON_LENGTH = 4;

    private PasswordValidate() {
    }

    public static ApiResponse<String> validPassword(String password, String oldPassword, Boolean isManager) {
        if (PasswordValidate.isEmpty(password)) {
            return new ApiResponse<String>(-1L, "Fail", "\u5bc6\u7801\u4e0d\u53ef\u4e3a\u7a7a\u6216\u5168\u4e3a\u7a7a\u683c");
        }
        if (isManager.booleanValue() && !PasswordValidate.passwordLength(password, true)) {
            return new ApiResponse<String>(-1L, "Fail", "\u7ba1\u7406\u5458\u5bc6\u7801\u957f\u5ea6\u5e94\u4e3a12-20\uff0c\u5e94\u81f3\u5c11\u4f7f\u7528\u6570\u5b57\uff0c\u5927\u5199\u5b57\u6bcd\uff0c\u5c0f\u5199\u5b57\u6bcd\uff0c\u7279\u6b8a\u7b26\u53f7\u4e2d\u7684\u4e24\u79cd");
        }
        if (!PasswordValidate.isEmpty(oldPassword)) {
            if (PasswordValidate.isLoop(password, oldPassword)) {
                return new ApiResponse<String>(-1L, "Fail", "\u65b0\u5bc6\u7801\u4e0d\u80fd\u662f\u65e7\u5bc6\u7801\u7684\u56de\u6587");
            }
            if (password.equalsIgnoreCase(oldPassword)) {
                return new ApiResponse<String>(-1L, "Fail", "\u65b0\u5bc6\u7801\u4e0d\u80fd\u662f\u65e7\u5bc6\u7801\u6539\u4e86\u5927\u5c0f\u5199\u6216\u8005\u524d\u540e\u5bc6\u7801\u4e00\u81f4");
            }
            if (PasswordValidate.isCircle(password, oldPassword)) {
                return new ApiResponse<String>(-1L, "Fail", "\u65b0\u5bc6\u7801\u4e0d\u80fd\u662f\u65e7\u5bc6\u7801\u7684\u4e00\u4e2a\u5faa\u73af");
            }
            if (PasswordValidate.isEqual(password, oldPassword, 4)) {
                return new ApiResponse<String>(-1L, "Fail", "\u4e0d\u80fd\u6709\u8fde\u7eed\u76844\u4f4d\u91cd\u590d");
            }
        }
        return PasswordValidate.validPassword(password);
    }

    public static ApiResponse<String> validPassword(String password) {
        if (PasswordValidate.isEmpty(password)) {
            return new ApiResponse<String>(-1L, "Fail", "\u5bc6\u7801\u4e0d\u53ef\u4e3a\u7a7a\u6216\u5168\u4e3a\u7a7a\u683c");
        }
        if (!PasswordValidate.passwordLength(password, false)) {
            return new ApiResponse<String>(-1L, "Fail", "\u5bc6\u7801\u957f\u5ea6\u4e3a8-20\uff0c\u5e94\u81f3\u5c11\u4f7f\u7528\u6570\u5b57\uff0c\u5927\u5199\u5b57\u6bcd\uff0c\u5c0f\u5199\u5b57\u6bcd\uff0c\u7279\u6b8a\u7b26\u53f7\u4e2d\u7684\u4e24\u79cd");
        }
        if (PasswordValidate.isSameChar(password)) {
            return new ApiResponse<String>(-1L, "Fail", "\u5bc6\u7801\u4e0d\u53ef\u4e3a\u540c\u4e00\u4e2a\u5b57\u7b26\u7684\u91cd\u590d\u5e8f\u5217\uff0c\u8bf7\u91cd\u65b0\u8bbe\u5b9a");
        }
        if (PasswordValidate.isRepeatChar(password)) {
            return new ApiResponse<String>(-1L, "Fail", "\u5bc6\u7801\u4e2d\u540c\u4e00\u4e2a\u5b57\u7b26\u4e0d\u53ef\u4ee5\u91cd\u590d\u51fa\u73b0\u4e09\u6b21\u6216\u4ee5\u4e0a\uff0c\u5efa\u8bae\u4fee\u6539");
        }
        if (PasswordValidate.isOrderList(password)) {
            return new ApiResponse<String>(-1L, "Fail", "\u5bc6\u7801\u4e0d\u53ef\u4ee5\u4e3a\u9012\u589e\u6570\u5217");
        }
        if (PasswordValidate.isDecreasing(password)) {
            return new ApiResponse<String>(-1L, "Fail", "\u5bc6\u7801\u4e0d\u53ef\u4ee5\u4e3a\u9012\u51cf\u6570\u5217");
        }
        if (PasswordValidate.isSequence(password)) {
            return new ApiResponse<String>(-1L, "Fail", "\u5bc6\u7801\u4e2d\u4e0d\u53ef\u4ee5\u6709\u8fde\u7eed\u7684\u6570\u5217\uff0c\u5982123,135,246,654\u7b49\u5f62\u5f0f");
        }
        if (PasswordValidate.isFourInRow(password)) {
            return new ApiResponse<String>(-1L, "Fail", "\u5bc6\u7801\u4e2d\u4e0d\u53ef\u4ee5\u6709\u591a\u4e2a\u8fde\u7eed\u5b57\u6bcd,\u5982abcd,dcba,1234asddjo\u62164321asddjo\u7b49\u5f62\u5f0f\uff0c\u8bf7\u91cd\u65b0\u8bbe\u5b9a");
        }
        if (!PasswordValidate.isKeyBoardList(password)) {
            return new ApiResponse<String>(-1L, "Fail", "\u5bc6\u7801\u4e2d\u4e0d\u53ef\u4ee5\u6709\u7279\u6b8a\u5e8f\u5217\uff0c\u5982qwer,asdf,zxcv\u7b49\uff0c\u8bf7\u91cd\u65b0\u8bbe\u5b9a");
        }
        if (!PasswordValidate.isPassType(password)) {
            return new ApiResponse<String>(-1L, "Fail", "\u5bc6\u7801\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u5bc6\u7801\u4e3a\u6570\u5b57\uff0c\u5927\u5c0f\u5199\u5b57\u7b26\uff0c\u7279\u6b8a\u7b26\u53f7\u4e2d\u81f3\u5c11\u4e24\u79cd");
        }
        if (PasswordValidate.isContainStrings(password)) {
            return new ApiResponse<String>(-1L, "Fail", "\u5bc6\u7801\u4e2d\u4e0d\u53ef\u4ee5\u5305\u542b\u5173\u952e\u5b57PICC\uff0c\u4e0d\u533a\u5206\u5927\u5c0f\u5199");
        }
        if (PasswordValidate.isCommonList(password)) {
            return new ApiResponse<String>(-1L, "Fail", "\u5bc6\u7801\u4e2d\u4e0d\u80fd\u6709\u5e38\u7528\u8bcd\uff0c\u5982admin\uff0cpicc\u7b49\uff0c\u4e0d\u533a\u5206\u5927\u5c0f\u5199");
        }
        return new ApiResponse<String>("\u5bc6\u7801\u6821\u9a8c\u901a\u8fc7");
    }

    private static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    private static boolean passwordLength(String str, Boolean isManager) {
        String passLength = "";
        passLength = isManager != false ? "^[\\d\\D]{12,20}$" : "^[\\d\\D]{8,20}$";
        return str.matches(passLength);
    }

    private static boolean isSameChar(String str) {
        boolean flag = true;
        char str1 = str.charAt(0);
        for (int i = 0; i < str.length(); ++i) {
            if (str1 != str.charAt(i)) {
                flag = false;
                break;
            }
            flag = true;
        }
        return flag;
    }

    private static boolean isOrderList(String str) {
        int i;
        for (i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        for (i = 0; i < str.length(); ++i) {
            if (i <= 0) continue;
            int num1 = Integer.parseInt(str.charAt(i - 1) + "") + 1;
            int num2 = Integer.parseInt(str.charAt(i) + "");
            if (num2 == num1) continue;
            return false;
        }
        return true;
    }

    private static boolean isDecreasing(String str) {
        int i;
        for (i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        for (i = 0; i < str.length(); ++i) {
            if (i <= 0) continue;
            int num1 = Integer.parseInt(str.charAt(i - 1) + "") - 1;
            int num2 = Integer.parseInt(str.charAt(i) + "");
            if (num2 == num1) continue;
            return false;
        }
        return true;
    }

    private static boolean isFourInRow(String str) {
        String[] str11 = str.split("");
        int cout = 0;
        for (int i = 0; i < str11.length - 1; ++i) {
            cout = str11[i].hashCode() != str11[i + 1].hashCode() && (str11[i + 1].hashCode() - str11[i].hashCode() == 1 || str11[i].hashCode() - str11[i + 1].hashCode() == 1) ? ++cout : 0;
            if (cout > 2) break;
        }
        return cout > 2;
    }

    private static boolean isPassType(String str) {
        String regFirst = "^[0-9a-zA-Z_\\W]{8,20}$";
        String regSecond = "^(?![0-9]+$)(?![a-z]+$)(?![A-Z]+$)(?![\\W]+$)[0-9a-zA-Z\\W_]+$";
        if (str.matches(regFirst)) {
            if (str.matches(regSecond)) {
                String regTwo = "^([0-9a-z_]+)|([0-9A-Z_]+)|([0-9_\\W]+)|([a-zA-Z_]+)([a-z_\\W]+)|([A-Z_\\W]+)$";
                String regThree = "^([0-9a-zA-Z_]+)|([0-9a-z_\\W]+)|([0-9A-Z_\\W]+)|([a-zA-Z_\\W]+)$";
                String regAll = "^[0-9a-zA-Z_\\W]+$";
                if (str.matches(regTwo)) {
                    log.info("\u5bc6\u7801\u542b\u6709\u4e24\u79cd\u5b57\u7b26\uff0c\u5f3a\u5ea6\u4e3a\u521d\u7ea7");
                    return true;
                }
                if (str.matches(regThree)) {
                    log.info("\u5bc6\u7801\u542b\u6709\u4e09\u79cd\u5b57\u7b26\uff0c\u5f3a\u5ea6\u4e3a\u4e2d\u7ea7");
                    return true;
                }
                if (str.matches(regAll)) {
                    log.info("\u5bc6\u7801\u542b\u6709\u56db\u79cd\u5b57\u7b26\uff0c\u5f3a\u5ea6\u4e3a\u9ad8\u7ea7");
                    return true;
                }
            } else {
                log.info("\u5bc6\u7801\u5f3a\u5ea6\u4e0d\u591f\u6e05\u91cd\u65b0\u8f93\u5165");
                return false;
            }
        }
        log.info("\u5bc6\u7801\u4f4d\u6570\u4e0d\u5bf9");
        return false;
    }

    private static boolean isKeyBoardList(String str) {
        PasswordValidate.isFirstList(str);
        PasswordValidate.isSecondList(str);
        PasswordValidate.isThirdList(str);
        String first = PasswordValidate.isFirstList(str);
        String second = PasswordValidate.isSecondList(str);
        String third = PasswordValidate.isThirdList(str);
        return "1".equals(first) && "1".equals(second) && "1".equals(third);
    }

    private static String isFirstList(String str) {
        int beginIndex;
        String[] strList = new String[]{"q", "w", "e", "r", "t", "y", "u", "i", "o", "p", "[", "]"};
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strList.length; ++i) {
            sb.append(strList[i]);
        }
        String str1 = sb.toString();
        for (int i = 0; i < str1.length() && (beginIndex = i) <= str1.length() - 4; ++i) {
            int endIndex = i + 4;
            String str11 = str1.substring(beginIndex, endIndex);
            boolean flag1 = str.contains(str11);
            boolean flag = flag1;
            if (!flag) continue;
            return "\u5305\u542b\u7ed9\u5b9a\u7684\u5b57\u7b26\u4e32\u5e8f\u5217\u7684\u8fde\u7eed\u5b50\u5e8f\u5217";
        }
        return "1";
    }

    private static String isSecondList(String str) {
        int beginIndex;
        String[] str1 = new String[]{"a", "s", "d", "f", "g", "h", "j", "k", "l", ";", ",", "\\"};
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str1.length; ++i) {
            sb.append(str1[i]);
        }
        String strAt1 = sb.toString();
        for (int i = 0; i < strAt1.length() && (beginIndex = i) <= strAt1.length() - 4; ++i) {
            int endIndex = i + 4;
            String strAt11 = strAt1.substring(beginIndex, endIndex);
            boolean flag1 = str.contains(strAt11);
            boolean flag = flag1;
            if (!flag) continue;
            return "\u5305\u542b\u7ed9\u5b9a\u7684\u5b57\u7b26\u4e32\u5e8f\u5217\u7684\u8fde\u7eed\u5b50\u5e8f\u5217";
        }
        return "1";
    }

    private static String isThirdList(String str) {
        int beginIndex;
        String[] str2 = new String[]{"z", "x", "c", "v", "b", "n", "m", ",", ".", "/"};
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str2.length; ++i) {
            sb.append(str2[i]);
        }
        String strAt1 = sb.toString();
        for (int i = 0; i < strAt1.length() && (beginIndex = i) <= strAt1.length() - 4; ++i) {
            int endIndex = i + 4;
            String strAt11 = strAt1.substring(beginIndex, endIndex);
            boolean flag1 = str.contains(strAt11);
            boolean flag = flag1;
            if (!flag) continue;
            return "\u5305\u542b\u7ed9\u5b9a\u7684\u5b57\u7b26\u4e32\u5e8f\u5217\u7684\u8fde\u7eed\u5b50\u5e8f\u5217";
        }
        return "1";
    }

    private static boolean isCommonList(String password) {
        ArrayList<String> commonList = new ArrayList<String>();
        boolean flag = false;
        commonList.add("admin");
        commonList.add("ADMIN");
        commonList.add(COMMON_PASS);
        commonList.add("PICC");
        commonList.add("user");
        commonList.add("USER");
        commonList.add("Picc");
        commonList.add("epicc");
        for (int i = 0; i < commonList.size() - 1; ++i) {
            flag = password.toLowerCase(Locale.US).contains(((String)commonList.get(i)).toLowerCase(Locale.US));
            if (!flag) continue;
            return flag;
        }
        return flag;
    }

    private static boolean isRepeatChar(String str) {
        boolean flag = false;
        int count = 0;
        for (int i = 0; i < str.length() - 1; ++i) {
            if (str.charAt(i) == str.charAt(i + 1)) {
                count = 0;
                char a = str.charAt(i);
                String strRepeat = str.substring(i);
                int b = strRepeat.length();
                for (int j = 0; j < b; ++j) {
                    if (strRepeat.charAt(j) != a || ++count != 3) continue;
                    log.info("\u91cd\u590d\u51fa\u73b0\u7684\u5b57\u7b26\u4e3a:{}\n\u51fa\u73b0\u7684\u6b21\u6570\u4e3a\uff1a{}\u6b21\u6216\u4ee5\u4e0a", (Object)Character.valueOf(a), (Object)count);
                    flag = true;
                    return flag;
                }
            }
            if (count >= 3) continue;
            count = 0;
        }
        return flag;
    }

    private static boolean isContainStrings(String pass) {
        boolean flag = false;
        char b = COMMON_PASS.charAt(0);
        String str = pass.toLowerCase(Locale.US);
        String c = "";
        int subLength = 4;
        for (int i = 0; i < str.length() - 1; ++i) {
            if (str.charAt(i) != b) continue;
            c = i + subLength <= str.length() ? str.substring(i, i + subLength) : str.substring(i);
            if (c.equalsIgnoreCase(COMMON_PASS)) {
                flag = true;
                return flag;
            }
            flag = false;
            return flag;
        }
        return flag;
    }

    private static boolean isSequence(String pass) {
        Matcher m = DIGIT3_PATTERN.matcher(pass);
        int i = 0;
        boolean flag = false;
        while (m.find()) {
            log.info("\u51fa\u73b0\u7684\u4e09\u4e2a\u4ee5\u4e0a\u8fde\u7eed\u6570\u5b57\u7247\u6bb5\u6570\u4f4d\uff1a\u7b2c" + ++i + "\u6bb5");
            log.info(m.group());
            String str = m.group();
            for (int j = 0; j < str.length() - 2; ++j) {
                int num2;
                int num = Integer.parseInt(str.charAt(j) + "");
                int num1 = Integer.parseInt(str.charAt(j + 1) + "");
                if (num1 - num != (num2 = Integer.parseInt(str.charAt(j + 2) + "")) - num1) continue;
                flag = true;
                return flag;
            }
        }
        return flag;
    }

    private static boolean isLoop(String password, String oldPassword) {
        StringBuilder sb = new StringBuilder(password);
        sb.reverse();
        String str2 = sb.toString();
        return oldPassword.equals(str2);
    }

    private static boolean isEqual(String password, String oldPassword, int length) {
        StringBuilder sb = new StringBuilder(password);
        int len = sb.length();
        int size = (len - len % length) / length;
        boolean flag = false;
        for (int i = 0; i < size; ++i) {
            String str = sb.substring(i * length, (i + 1) * length);
            if (!oldPassword.contains(str)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static boolean isCircle(String password, String oldPassword) {
        boolean flag = false;
        if (password.length() == oldPassword.length()) {
            char[] temp = password.toCharArray();
            for (int i = 0; i <= temp.length; ++i) {
                for (int j = 0; j < temp.length - 1; ++j) {
                    char c = temp[j];
                    temp[j] = temp[j + 1];
                    temp[j + 1] = c;
                }
                if (!String.valueOf(temp).equals(oldPassword)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }
}

