/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.barcode;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.BarcodeUtil;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;
import org.krysalis.barcode4j.output.eps.EPSCanvasProvider;
import org.krysalis.barcode4j.output.svg.SVGCanvasProvider;
import org.w3c.dom.DocumentFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarcodeGen {
    public static byte[] generateBarcode(String msg, Map<String, String> map) {
        String format = "image/jpeg";
        String type = "code128";
        int orientation = 0;
        int resolution = 300;
        String height = "15mm";
        String width = "60mm";
        String font_size = "1.7mm";
        ByteArrayOutputStream bout = null;
        BarcodeUtil util = null;
        BarcodeGenerator gen = null;
        DefaultConfiguration cfg = new DefaultConfiguration("barcode");
        DefaultConfiguration codeType = new DefaultConfiguration(type);
        DefaultConfiguration picHeight = new DefaultConfiguration("height");
        DefaultConfiguration picWidth = new DefaultConfiguration("width");
        DefaultConfiguration humanReadable = new DefaultConfiguration("human-readable");
        DefaultConfiguration fontSize = new DefaultConfiguration("font-size");
        try {
            if (map != null) {
                Iterator<String> it = map.keySet().iterator();
                String key = null;
                String value = null;
                while (it.hasNext()) {
                    key = it.next();
                    value = map.get(key);
                    if ("picType".equals(key)) {
                        format = value;
                        continue;
                    }
                    if ("codeType".equals(key)) {
                        type = value;
                        codeType = new DefaultConfiguration(type);
                        continue;
                    }
                    if ("height".equals(key)) {
                        height = value;
                        continue;
                    }
                    if ("width".equals(key)) {
                        width = value;
                        continue;
                    }
                    if ("font-size".equals(key)) {
                        font_size = value;
                        continue;
                    }
                    if (!"resolution".equals(key)) continue;
                    resolution = Integer.parseInt(value);
                }
            }
            util = BarcodeUtil.getInstance();
            cfg.addChild((Configuration)codeType);
            fontSize.setValue(font_size);
            humanReadable.addChild((Configuration)fontSize);
            codeType.addChild((Configuration)humanReadable);
            picWidth.setValue(width);
            codeType.addChild((Configuration)picWidth);
            picHeight.setValue(height);
            codeType.addChild((Configuration)picHeight);
            gen = util.createBarcodeGenerator((Configuration)cfg);
            bout = new ByteArrayOutputStream(4096);
            if (format.equals("image/svg+xml")) {
                SVGCanvasProvider svg = new SVGCanvasProvider(false, orientation);
                gen.generateBarcode((CanvasProvider)svg, msg.trim());
                DocumentFragment frag = svg.getDOMFragment();
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer trans = factory.newTransformer();
                DOMSource src = new DOMSource(frag);
                StreamResult res = new StreamResult(bout);
                trans.transform(src, res);
            } else if (format.equals("image/x-eps")) {
                EPSCanvasProvider eps = new EPSCanvasProvider((OutputStream)bout, orientation);
                gen.generateBarcode((CanvasProvider)eps, msg);
                eps.finish();
            } else {
                BitmapCanvasProvider bitmap = new BitmapCanvasProvider((OutputStream)bout, format, resolution, 10, true, orientation);
                gen.generateBarcode((CanvasProvider)bitmap, msg);
                bitmap.finish();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        finally {
            if (bout != null) {
                try {
                    bout.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
        }
        return bout.toByteArray();
    }

    public static void generateBarcodeFile(String msg, String filePath, Map<String, String> map) {
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(new File(filePath));
            output.write(BarcodeGen.generateBarcode(msg, map));
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
        }
    }
}

