/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.barcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.GlobalHistogramBinarizer;
import com.google.zxing.common.HybridBinarizer;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;

public class BarcodeParser {
    private static final Hashtable<DecodeHintType, Object> HINTS = new Hashtable(5);
    private static final Hashtable<DecodeHintType, Object> HINTS_PURE;

    public static String getBarcodeContent(String fileName) {
        BufferedImage image;
        try {
            image = ImageIO.read(new File(fileName));
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        MultiFormatReader reader = new MultiFormatReader();
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new GlobalHistogramBinarizer((LuminanceSource)source));
        Result result = null;
        try {
            result = reader.decode(bitmap, HINTS_PURE);
        }
        catch (ReaderException e) {
            // empty catch block
        }
        if (result == null) {
            try {
                result = reader.decode(bitmap, HINTS);
            }
            catch (ReaderException e) {
                // empty catch block
            }
        }
        if (result == null) {
            try {
                BinaryBitmap hybridBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
                result = reader.decode(hybridBitmap, HINTS);
            }
            catch (ReaderException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        return result.getText();
    }

    static {
        HINTS.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
        Vector<BarcodeFormat> possibleFormats = new Vector<BarcodeFormat>();
        possibleFormats.add(BarcodeFormat.UPC_A);
        possibleFormats.add(BarcodeFormat.UPC_E);
        possibleFormats.add(BarcodeFormat.EAN_8);
        possibleFormats.add(BarcodeFormat.EAN_13);
        possibleFormats.add(BarcodeFormat.CODE_39);
        possibleFormats.add(BarcodeFormat.CODE_128);
        possibleFormats.add(BarcodeFormat.ITF);
        possibleFormats.add(BarcodeFormat.RSS14);
        possibleFormats.add(BarcodeFormat.QR_CODE);
        possibleFormats.add(BarcodeFormat.DATAMATRIX);
        possibleFormats.add(BarcodeFormat.PDF417);
        HINTS.put(DecodeHintType.POSSIBLE_FORMATS, possibleFormats);
        HINTS_PURE = new Hashtable<DecodeHintType, Object>(HINTS);
        HINTS_PURE.put(DecodeHintType.PURE_BARCODE, Boolean.TRUE);
    }
}

