/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Page
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_PAGE_SIZE = 20;
    private int pageSize = 20;
    private long start;
    private List data;
    private long totalCount;
    private String message;

    public Page() {
        this(0L, 0L, 20, new ArrayList());
    }

    public Page(long start, long totalSize, int pageSize, List data) {
        this.pageSize = pageSize;
        this.start = start;
        this.totalCount = totalSize;
        this.data = data;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public long getTotalPageCount() {
        if (this.totalCount % (long)this.pageSize == 0L) {
            return this.totalCount / (long)this.pageSize;
        }
        return this.totalCount / (long)this.pageSize + 1L;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public List getResult() {
        return this.data;
    }

    public long getCurrentPageNo() {
        return this.start / (long)this.pageSize + 1L;
    }

    public boolean hasNextPage() {
        return this.getCurrentPageNo() < this.getTotalPageCount() - 1L;
    }

    public boolean hasPreviousPage() {
        return this.getCurrentPageNo() > 1L;
    }

    protected static int getStartOfPage(int pageNo) {
        return Page.getStartOfPage(pageNo, 20);
    }

    public static int getStartOfPage(int pageNo, int pageSize) {
        return (pageNo - 1) * pageSize;
    }

    public long getStart() {
        return this.start;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

