/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.dao;

import ins.framework.common.Page;
import ins.framework.common.QueryRule;
import ins.framework.dao.support.QueryRuleUtils;
import ins.framework.multicache.Caches;
import ins.framework.utils.BeanUtils;
import ins.framework.utils.DataUtils;
import ins.framework.utils.StringUtils;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.annotations.Type;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.impl.CriteriaImpl;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityDaoHibernate
extends HibernateDaoSupport
implements ApplicationContextAware {
    protected ApplicationContext applicationContext;
    private static final String CACHEABLE_KEY = "CACHEABLE_KEY";
    private static final int DEFAULT_PAGE_SIZE = 10;
    private static boolean optimizeFind;
    private static Map<String, String> ignoreFieldNameMapAtSaveBySql;
    static Pattern hqlQueryCacheFlagPattern;

    public static Map<String, String> getIgnoreFieldNameMapAtSaveBySql() {
        return ignoreFieldNameMapAtSaveBySql;
    }

    public static boolean isOptimizeFind() {
        return optimizeFind;
    }

    public static void setOptimizeFind(boolean optimizeFind) {
        EntityDaoHibernate.optimizeFind = optimizeFind;
    }

    protected boolean isCacheable(Session session) {
        Boolean cacheable = (Boolean)Caches.THREAD.get(CACHEABLE_KEY, EntityDaoHibernate.class, System.identityHashCode(session));
        return cacheable == null ? true : cacheable;
    }

    protected void setCacheable(Session session, boolean cacheable) {
        Caches.THREAD.set(CACHEABLE_KEY, EntityDaoHibernate.class, System.identityHashCode(session), cacheable);
    }

    protected boolean isCacheable() {
        return this.isCacheable((Session)this.getSessionFactory().getCurrentSession());
    }

    protected void setCacheable(boolean cacheable) {
        this.setCacheable((Session)this.getSessionFactory().getCurrentSession(), cacheable);
    }

    public <T> T get(Class<T> entityClass, Serializable id) {
        return (T)this.getHibernateTemplate().get(entityClass, id);
    }

    public <T> List<T> getAll(Class<T> entityClass) {
        return this.getHibernateTemplate().loadAll(entityClass);
    }

    public void save(Object obj) {
        this.getHibernateTemplate().saveOrUpdate(obj);
    }

    public void update(Object obj) {
        this.getHibernateTemplate().update(obj);
    }

    public void saveAll(List list) {
        this.getHibernateTemplate().saveOrUpdateAll((Collection)list);
    }

    public void delete(Object obj) {
        this.getHibernateTemplate().delete(obj);
    }

    public <T> void deleteAll(List entityList) {
        this.getHibernateTemplate().deleteAll((Collection)entityList);
    }

    public <T> void deleteByPK(Class<T> entityClass, Serializable id) {
        T obj = this.get(entityClass, id);
        if (obj != null) {
            this.delete(obj);
        }
    }

    public void flush() {
        this.getHibernateTemplate().flush();
    }

    public void evict(Object obj) {
        this.getHibernateTemplate().evict(obj);
    }

    public void clear() {
        this.getHibernateTemplate().clear();
    }

    public List findByHql(String hql, final Object ... values) {
        Assert.hasText((String)hql);
        String newHql = hql;
        int pos = 0;
        if (values != null) {
            for (int i = 0; i < values.length && (pos = newHql.indexOf(63, pos)) != -1; ++i) {
                if (values[i] instanceof Collection && pos > -1) {
                    newHql = newHql.substring(0, pos) + ":queryParam" + i + newHql.substring(pos + 1);
                }
                ++pos;
            }
        }
        final String fnHql = newHql;
        List list = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws SQLException {
                Query query = EntityDaoHibernate.this.createQuery(fnHql, session);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        if (values[i] instanceof Collection) {
                            query.setParameterList("queryParam" + i, (Collection)values[i]);
                            continue;
                        }
                        query.setParameter(i, values[i]);
                    }
                }
                return query.list();
            }
        });
        return list;
    }

    public List findTopByHql(String hql, final int top, final Object ... values) {
        String newHql = hql;
        int pos = 0;
        if (values != null) {
            for (int i = 0; i < values.length && (pos = newHql.indexOf(63, pos)) != -1; ++i) {
                if (values[i] instanceof Collection && pos > -1) {
                    newHql = newHql.substring(0, pos) + ":queryParam" + i + newHql.substring(pos + 1);
                }
                ++pos;
            }
        }
        final String fnHql = newHql;
        List list = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws SQLException {
                Query query = EntityDaoHibernate.this.createQuery(fnHql, session);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        if (values[i] instanceof Collection) {
                            query.setParameterList("queryParam" + i, (Collection)values[i]);
                            continue;
                        }
                        query.setParameter(i, values[i]);
                    }
                }
                query.setFirstResult(0);
                query.setMaxResults(top);
                return query.list();
            }
        });
        return list;
    }

    public Page findByHql(String hql, Integer pageNo, Integer pageSize, final Object ... values) {
        Assert.hasText((String)hql);
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (pageSize <= 0) {
            pageSize = 10;
        }
        String newHql = hql;
        int pos = 0;
        if (values != null) {
            for (int i = 0; i < values.length && (pos = newHql.indexOf(63, pos)) != -1; ++i) {
                if (values[i] instanceof Collection && pos > -1) {
                    newHql = newHql.substring(0, pos) + ":queryParam" + i + newHql.substring(pos + 1);
                }
                ++pos;
            }
        }
        final String fnHql = newHql;
        final int startIndex = Page.getStartOfPage(pageNo, pageSize);
        if (startIndex < 0) {
            return new Page();
        }
        if (optimizeFind && pageNo > 1) {
            final int realPageSize = pageSize;
            List list = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws SQLException {
                    Query query = EntityDaoHibernate.this.createQuery(fnHql, session);
                    if (values != null) {
                        for (int i = 0; i < values.length; ++i) {
                            if (values[i] instanceof Collection) {
                                query.setParameterList("queryParam" + i, (Collection)values[i]);
                                continue;
                            }
                            query.setParameter(i, values[i]);
                        }
                    }
                    query.setFirstResult(startIndex);
                    query.setMaxResults(realPageSize);
                    return query.list();
                }
            });
            return new Page(startIndex, -1L, pageSize, list);
        }
        int maxCount = 100;
        String modifyHql = null;
        final boolean isIncludeDistinctFlag = EntityDaoHibernate.isIncludeDistinct(fnHql);
        modifyHql = isIncludeDistinctFlag ? EntityDaoHibernate.getDistinctCountHql(fnHql) + EntityDaoHibernate.removeSelect(EntityDaoHibernate.removeOrders(fnHql)) : " select 1 " + EntityDaoHibernate.removeSelect(EntityDaoHibernate.removeOrders(fnHql));
        final String countQueryString = modifyHql;
        List countList = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws SQLException {
                Query query = EntityDaoHibernate.this.createQuery(countQueryString, session);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        if (values[i] instanceof Collection) {
                            query.setParameterList("queryParam" + i, (Collection)values[i]);
                            continue;
                        }
                        query.setParameter(i, values[i]);
                    }
                }
                if (!isIncludeDistinctFlag) {
                    query.setFirstResult(startIndex);
                    query.setMaxResults(100 - startIndex);
                }
                return query.list();
            }
        });
        long totalCount = 0L;
        if (isIncludeDistinctFlag) {
            totalCount = (Long)countList.get(0);
            if (totalCount < 1L) {
                return new Page();
            }
        } else {
            if (countList.size() < 1) {
                return new Page();
            }
            totalCount = startIndex + countList.size();
        }
        final int realPageSize = pageSize;
        List list = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws SQLException {
                Query query = EntityDaoHibernate.this.createQuery(fnHql, session);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        if (values[i] instanceof Collection) {
                            query.setParameterList("queryParam" + i, (Collection)values[i]);
                            continue;
                        }
                        query.setParameter(i, values[i]);
                    }
                }
                query.setFirstResult(startIndex);
                query.setMaxResults(realPageSize);
                return query.list();
            }
        });
        return new Page(startIndex, totalCount, pageSize, list);
    }

    public Page findByHqlNoLimit(String hql, int pageNo, int pageSize, final Object ... values) {
        Assert.hasText((String)hql);
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (pageSize == 0) {
            pageSize = 10;
        }
        String newHql = hql;
        int pos = 0;
        if (values != null) {
            for (int i = 0; i < values.length && (pos = newHql.indexOf(63, pos)) != -1; ++i) {
                if (values[i] instanceof Collection && pos > -1) {
                    newHql = newHql.substring(0, pos) + ":queryParam" + i + newHql.substring(pos + 1);
                }
                ++pos;
            }
        }
        final String fnHql = newHql;
        final StringBuffer countQueryString = new StringBuffer(fnHql.length() + 20).append(" select count (*) ").append(EntityDaoHibernate.removeSelect(EntityDaoHibernate.removeOrders(fnHql)));
        List countlist = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws SQLException {
                Query query = session.createQuery(countQueryString.toString());
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        if (values[i] instanceof Collection) {
                            query.setParameterList("queryParam" + i, (Collection)values[i]);
                            continue;
                        }
                        query.setParameter(i, values[i]);
                    }
                }
                return query.list();
            }
        });
        long totalCount = (Long)countlist.get(0);
        if (totalCount < 1L) {
            return new Page();
        }
        final int realPageSize = pageSize;
        final int startIndex = Page.getStartOfPage(pageNo, pageSize);
        List list = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws SQLException {
                Query query = EntityDaoHibernate.this.createQuery(fnHql, session);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        if (values[i] instanceof Collection) {
                            query.setParameterList("queryParam" + i, (Collection)values[i]);
                            continue;
                        }
                        query.setParameter(i, values[i]);
                    }
                }
                query.setFirstResult(startIndex);
                query.setMaxResults(realPageSize);
                return query.list();
            }
        });
        return new Page(startIndex, totalCount, pageSize, list);
    }

    public <T> T findUnique(Class<T> entityClass, String propertyName, Object value) {
        QueryRule queryRule = QueryRule.getInstance();
        queryRule.addEqual(propertyName, value);
        List list = this.find(entityClass, queryRule);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return (T)list.get(0);
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)StringUtils.concat("findUnique return ", list.size(), " record(s). EntityClass=", entityClass.getClass().getName(), ",propertyName=", propertyName, ",value=", value));
        }
        throw new IllegalStateException("findUnique return " + list.size() + " record(s).");
    }

    public <T> boolean exists(Class<T> entityClass, Serializable id) {
        Object entity = super.getHibernateTemplate().get(entityClass, id);
        return entity != null;
    }

    public long getCount(String hql, Object ... values) {
        Assert.hasText((String)hql);
        StringBuffer countQueryString = new StringBuffer(hql.length() + 20).append(" select count (*) ").append(EntityDaoHibernate.removeSelect(EntityDaoHibernate.removeOrders(hql)));
        List countlist = this.getHibernateTemplate().find(countQueryString.toString(), values);
        return (Long)countlist.get(0);
    }

    protected static String removeSelect(String hql) {
        Assert.hasText((String)hql);
        int beginPos = hql.toLowerCase(Locale.US).indexOf("from");
        Assert.isTrue((beginPos != -1 ? 1 : 0) != 0, (String)(" hql : " + hql + " must has a keyword 'from'"));
        return hql.substring(beginPos);
    }

    protected static String removeOrders(String hql) {
        Assert.hasText((String)hql);
        Pattern p = Pattern.compile("order\\s*by[\\w|\\W|\\s|\\S]*", 2);
        Matcher m = p.matcher(hql);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    protected static boolean isIncludeDistinct(String hql) {
        String hqlLowerCase = hql.toLowerCase(Locale.US);
        return (hqlLowerCase = hqlLowerCase.replace(" ", "")).startsWith("selectdistinct");
    }

    protected static String getDistinctCountHql(String hql) {
        String hqlSelect = hql.toLowerCase(Locale.US).split("from")[0];
        String hqlSelectDistinct = hqlSelect.split(",")[0];
        hqlSelectDistinct = hql.substring(0, hqlSelectDistinct.length());
        String coml = hqlSelectDistinct.split("distinct")[1];
        coml = coml.replace("(", " ");
        coml = coml.replace(")", " ");
        return "select count(distinct " + coml + ")";
    }

    public <T> List find(final Class<T> entityClass, final QueryRule queryRule) {
        List list = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws SQLException {
                Criteria criteria = session.createCriteria(entityClass);
                QueryRuleUtils.createCriteriaWithQueryRule(criteria, queryRule);
                List<Order> orders = EntityDaoHibernate.this.getOrderFromQueryRule(queryRule);
                for (Order o : orders) {
                    criteria.addOrder(o);
                }
                EntityDaoHibernate.this.wrapCriteria(criteria);
                return criteria.setFirstResult(0).list();
            }
        });
        return list;
    }

    public <T> Page find(final Class<T> entityClass, final QueryRule queryRule, int pageNo, int pageSize) {
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (pageSize == 0) {
            pageSize = 10;
        }
        final int realPageNo = pageNo;
        final int realPageSize = pageSize;
        if (optimizeFind && pageNo > 1) {
            Page page = (Page)this.getHibernateTemplate().execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws SQLException {
                    Criteria criteria = session.createCriteria(entityClass);
                    QueryRuleUtils.createCriteriaWithQueryRule(criteria, queryRule);
                    List<Order> orders = EntityDaoHibernate.this.getOrderFromQueryRule(queryRule);
                    for (Order o : orders) {
                        criteria.addOrder(o);
                    }
                    int startIndex = Page.getStartOfPage(realPageNo, realPageSize);
                    List list = EntityDaoHibernate.this.fetch(criteria, startIndex, realPageSize);
                    return new Page(startIndex, -1L, realPageSize, list);
                }
            });
            return page;
        }
        Page page = (Page)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws SQLException {
                List orderEntries;
                Criteria criteria = session.createCriteria(entityClass);
                QueryRuleUtils.createCriteriaWithQueryRule(criteria, queryRule);
                CriteriaImpl impl = (CriteriaImpl)criteria;
                Projection projection = impl.getProjection();
                try {
                    orderEntries = (List)BeanUtils.forceGetProperty(impl, "orderEntries");
                    BeanUtils.forceSetProperty(impl, "orderEntries", new ArrayList());
                }
                catch (Exception e) {
                    throw new InternalError(" Runtime Exception impossibility throw ");
                }
                long totalCount = Long.valueOf("" + criteria.setProjection(Projections.rowCount()).uniqueResult());
                criteria.setProjection(projection);
                if (projection == null) {
                    criteria.setResultTransformer(CriteriaSpecification.ROOT_ENTITY);
                }
                try {
                    BeanUtils.forceSetProperty(impl, "orderEntries", orderEntries);
                }
                catch (Exception e) {
                    throw new InternalError(" Runtime Exception impossibility throw ");
                }
                if (totalCount < 1L) {
                    return new Page();
                }
                List<Order> orders = EntityDaoHibernate.this.getOrderFromQueryRule(queryRule);
                for (Order o : orders) {
                    criteria.addOrder(o);
                }
                int startIndex = Page.getStartOfPage(realPageNo, realPageSize);
                List list = EntityDaoHibernate.this.fetch(criteria, startIndex, realPageSize);
                return new Page(startIndex, totalCount, realPageSize, list);
            }
        });
        return page;
    }

    protected List<Order> getOrderFromQueryRule(QueryRule queryRule) {
        ArrayList<Order> orders = new ArrayList<Order>();
        for (QueryRule.Rule rule : queryRule.getRuleList()) {
            switch (rule.getType()) {
                case 101: {
                    if (!StringUtils.isNotEmpty((String)rule.getPropertyName())) break;
                    orders.add(Order.asc((String)rule.getPropertyName()));
                    break;
                }
                case 102: {
                    if (!StringUtils.isNotEmpty((String)rule.getPropertyName())) break;
                    orders.add(Order.desc((String)rule.getPropertyName()));
                    break;
                }
            }
        }
        return orders;
    }

    public <T> T findUnique(Class<T> entityClass, Map<String, Object> properties) {
        QueryRule queryRule = QueryRule.getInstance();
        for (String key : properties.keySet()) {
            queryRule.addEqual(key, properties.get(key));
        }
        return this.findUnique(entityClass, queryRule);
    }

    public <T> T findUnique(Class<T> entityClass, QueryRule queryRule) {
        List list = this.find(entityClass, queryRule);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return (T)list.get(0);
        }
        if (this.logger.isWarnEnabled()) {
            List<QueryRule.Rule> ruleList = queryRule.getRuleList();
            StringBuilder buf = new StringBuilder();
            buf.append("findUnique return ").append(list.size()).append(" record(s). EntityClass=").append(entityClass.getClass().getName()).append(").append(queryRule={");
            if (ruleList != null) {
                for (int i = 0; i < ruleList.size(); ++i) {
                    QueryRule.Rule rule = ruleList.get(i);
                    if (rule == null) continue;
                    buf.append(ToStringBuilder.reflectionToString((Object)rule));
                    if (i >= ruleList.size() - 1) continue;
                    buf.append(",");
                }
            }
            buf.append("}");
            this.logger.warn((Object)buf.toString());
        }
        throw new IllegalStateException("findUnique return " + list.size() + " record(s).");
    }

    public <T> Page pagination(List<T> objList, int pageNo, int pageSize) {
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (pageSize == 0) {
            pageSize = 10;
        }
        ArrayList<T> objectArray = new ArrayList<T>(0);
        int startIndex = (pageNo - 1) * pageSize;
        int endIndex = pageNo * pageSize;
        for (int i = startIndex; i < endIndex; ++i) {
            objectArray.add(objList.get(i));
        }
        return new Page(startIndex, objList.size(), pageSize, objectArray);
    }

    public void mergeList(List pojoList, List poList, String idName) {
        this.mergeList(pojoList, poList, idName, false);
    }

    public void mergeList(List pojoList, List poList, String idName, boolean isCopyNull) {
        Object key;
        Object element;
        HashMap map = new HashMap();
        HashMap<Integer, Object> keyMap = new HashMap<Integer, Object>();
        HashMap poMap = new HashMap();
        ArrayList delPoList = new ArrayList();
        int count = pojoList.size();
        for (int i = 0; i < count; ++i) {
            element = pojoList.get(i);
            if (element == null) continue;
            try {
                key = PropertyUtils.getProperty(element, (String)idName);
                map.put(key, element);
                keyMap.put(i, key);
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        Iterator it = poList.iterator();
        while (it.hasNext()) {
            Object element2 = it.next();
            try {
                Object key2 = PropertyUtils.getProperty(element2, (String)idName);
                poMap.put(key2, null);
                if (!map.containsKey(key2)) {
                    delPoList.add(element2);
                    it.remove();
                    continue;
                }
                DataUtils.copySimpleObjectToTargetFromSource(element2, map.get(key2), isCopyNull);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        count = pojoList.size();
        for (int i = 0; i < count; ++i) {
            element = pojoList.get(i);
            if (element == null) continue;
            key = keyMap.get(i);
            if (key == null) {
                if (delPoList.size() > 0) {
                    Object delPoObject = delPoList.get(0);
                    delPoList.remove(0);
                    try {
                        Object delPoKey = PropertyUtils.getProperty(delPoObject, (String)idName);
                        DataUtils.copySimpleObjectToTargetFromSource(delPoObject, element, true);
                        PropertyUtils.setProperty(delPoObject, (String)idName, (Object)delPoKey);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(e);
                    }
                    poList.add(delPoObject);
                    continue;
                }
                poList.add(element);
                continue;
            }
            if (poMap.containsKey(key)) continue;
            poList.add(element);
        }
        for (Object delPo : delPoList) {
            this.delete(delPo);
        }
    }

    public Long getSequence(final String sequenceName) {
        Long seq = (Long)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws SQLException {
                SQLQuery sqlQuery = session.createSQLQuery("select " + sequenceName + ".nextval from systables where tabid=1");
                List list = sqlQuery.list();
                return Long.valueOf("" + list.get(0));
            }
        });
        return seq;
    }

    public List findUnionBySql(final String sql, final Object ... values) {
        Assert.hasText((String)sql);
        Assert.isTrue((sql.toLowerCase(Locale.US).indexOf("union") != -1 ? 1 : 0) != 0);
        List list = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                SQLQuery query = session.createSQLQuery(sql);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        query.setParameter(i, values[i]);
                    }
                }
                return query.list();
            }
        });
        return list;
    }

    public Page findUnionByHqls(List<String> hqls, List<List<Object>> valuess, int pageNo, int pageSize) {
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (pageSize == 0) {
            pageSize = 10;
        }
        Long[] counts = new Long[hqls.size()];
        long totalCount = 0L;
        for (int k = 0; k < hqls.size(); ++k) {
            String newHql = hqls.get(k);
            final Object[] values = valuess.get(k).toArray();
            int pos = 0;
            if (values != null) {
                for (int i = 0; i < values.length && (pos = newHql.indexOf(63, pos)) != -1; ++i) {
                    if (values[i] instanceof Collection && pos > -1) {
                        newHql = newHql.substring(0, pos) + ":queryParam" + i + newHql.substring(pos + 1);
                    }
                    ++pos;
                }
            }
            String fnHql = newHql;
            final StringBuffer countQueryString = new StringBuffer(fnHql.length() + 20).append(" select count (*) ").append(EntityDaoHibernate.removeSelect(EntityDaoHibernate.removeOrders(fnHql)));
            List countlist = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws SQLException {
                    Query query = session.createQuery(countQueryString.toString());
                    if (values != null) {
                        for (int i = 0; i < values.length; ++i) {
                            if (values[i] instanceof Collection) {
                                query.setParameterList("queryParam" + i, (Collection)values[i]);
                                continue;
                            }
                            query.setParameter(i, values[i]);
                        }
                    }
                    return query.list();
                }
            });
            counts[k] = (Long)countlist.get(0);
            totalCount += counts[k].longValue();
        }
        ArrayList<List> datas = new ArrayList<List>();
        int startIndex = Page.getStartOfPage(pageNo, pageSize);
        long gindex = 0L;
        long selectCount = 0L;
        for (int k = 0; k < hqls.size(); ++k) {
            final String fnHql = hqls.get(k);
            final Object[] values = valuess.get(k).toArray();
            long realIndex = (long)startIndex - gindex;
            long realSize = (long)pageSize - selectCount;
            if (realIndex < 0L) {
                realIndex = 0L;
            }
            if (counts[k] - realIndex < realSize) {
                realSize = counts[k] - realIndex;
            }
            final long fnRealIndex = realIndex;
            final long fnRealSize = realSize;
            if (realIndex >= 0L && realSize > 0L) {
                List list = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                    public Object doInHibernate(Session session) throws SQLException {
                        Query query = EntityDaoHibernate.this.createQuery(fnHql, session);
                        if (values != null) {
                            for (int i = 0; i < values.length; ++i) {
                                if (values[i] instanceof Collection) {
                                    query.setParameterList("queryParam" + i, (Collection)values[i]);
                                    continue;
                                }
                                query.setParameter(i, values[i]);
                            }
                        }
                        query.setFirstResult((int)fnRealIndex);
                        query.setMaxResults((int)fnRealSize);
                        return query.list();
                    }
                });
                datas.add(list);
                selectCount += fnRealSize;
            }
            if (selectCount == (long)pageSize) break;
            gindex += counts[k].longValue();
        }
        ArrayList resultList = new ArrayList();
        for (int i = 0; i < datas.size(); ++i) {
            resultList.addAll((Collection)datas.get(i));
        }
        return new Page(startIndex, totalCount, pageSize, resultList);
    }

    public Page findTopUnionByHqls(List<String> hqls, int top, List<List<Object>> valuess) {
        ArrayList<List> datas = new ArrayList<List>();
        int selectCount = 0;
        for (int i = 0; i < hqls.size(); ++i) {
            final String fnHql = hqls.get(i);
            final Object[] values = valuess.get(i).toArray();
            final int maxCount = top - selectCount;
            List list = this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws SQLException {
                    Query query = EntityDaoHibernate.this.createQuery(fnHql, session);
                    if (values != null) {
                        for (int j = 0; j < values.length; ++j) {
                            if (values[j] instanceof Collection) {
                                query.setParameterList("queryParam" + j, (Collection)values[j]);
                                continue;
                            }
                            query.setParameter(j, values[j]);
                        }
                    }
                    query.setMaxResults(maxCount);
                    return query.list();
                }
            });
            datas.add(list);
            if ((selectCount += list.size()) >= top) break;
        }
        ArrayList resultList = new ArrayList();
        for (int i = 0; i < datas.size(); ++i) {
            resultList.addAll((Collection)datas.get(i));
        }
        return new Page(1L, selectCount, selectCount, resultList);
    }

    public List findBySql(final String sql, final Object ... values) {
        Assert.hasText((String)sql);
        List list = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws SQLException {
                SQLQuery query = session.createSQLQuery(sql);
                if (values != null) {
                    for (int i = 0; i < values.length; ++i) {
                        query.setParameter(i, values[i]);
                    }
                }
                return query.list();
            }
        });
        return list;
    }

    public void saveBySql(Object pojo) {
        try {
            HashMap<String, Object> savedMap = new HashMap<String, Object>();
            this.saveBySqlInner(pojo, savedMap);
            this.getHibernateTemplate().merge(pojo);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Method findPojoIdMethod(Object pojo) {
        Class<?> cls = pojo.getClass();
        List<Method> getterMethodList = BeanUtils.getGetter(cls);
        for (int i = 0; i < getterMethodList.size(); ++i) {
            Method method = getterMethodList.get(i);
            Id annoObj = method.getAnnotation(Id.class);
            if (annoObj == null) continue;
            return method;
        }
        return null;
    }

    private void saveBySqlInner(Object pojo, Map<String, Object> savedMap) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int i;
        int i2;
        Class<?> cls = pojo.getClass();
        Table annoObj = cls.getAnnotation(Table.class);
        if (annoObj == null) {
            return;
        }
        String tableName = annoObj.name();
        List<Method> getterMethodList = BeanUtils.getGetter(cls);
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(tableName).append("(");
        int fieldCount = 0;
        Object[] zeroClass = new Class[]{};
        Object[] zeroObject = new Object[]{};
        ArrayList<Object> valueList = new ArrayList<Object>();
        ArrayList<Method> todoGetMethodList = new ArrayList<Method>();
        HashMap<String, String> fieldNameMap = new HashMap<String, String>();
        Object id = null;
        for (i2 = 0; i2 < getterMethodList.size(); ++i2) {
            Method method = getterMethodList.get(i2);
            annoObj = method.getAnnotation(Column.class);
            String fieldName = "";
            Object value = null;
            if (annoObj == null) {
                annoObj = method.getAnnotation(JoinColumn.class);
                if (annoObj == null) {
                    todoGetMethodList.add(method);
                    continue;
                }
                fieldName = ((JoinColumn)annoObj).name();
                if (fieldName == null || ignoreFieldNameMapAtSaveBySql.containsKey(fieldName.toLowerCase()) || fieldNameMap.containsKey(fieldName)) continue;
                fieldNameMap.put(fieldName, fieldName);
                Object parentObject = method.invoke(pojo, zeroObject);
                value = EntityDaoHibernate.findPojoIdMethod(parentObject).invoke(parentObject, zeroClass);
            } else {
                fieldName = ((Column)annoObj).name();
                if (fieldName == null || ignoreFieldNameMapAtSaveBySql.containsKey(fieldName.toLowerCase()) || fieldNameMap.containsKey(fieldName) || (annoObj = method.getAnnotation(Type.class)) != null && "org.springframework.orm.hibernate3.support.ClobStringType".equals(((Type)annoObj).type())) continue;
                fieldNameMap.put(fieldName, fieldName);
                value = method.invoke(pojo, zeroObject);
                if (id == null && method.getAnnotation(Id.class) != null) {
                    id = value;
                }
            }
            if (value == null) continue;
            valueList.add(value);
            sql.append(fieldName).append(",");
            ++fieldCount;
        }
        sql.setCharAt(sql.length() - 1, ')');
        sql.append(" values(");
        for (i2 = 0; i2 < fieldCount; ++i2) {
            sql.append("?,");
        }
        sql.setCharAt(sql.length() - 1, ')');
        String key = tableName + "|" + id;
        if (savedMap.containsKey(key)) {
            return;
        }
        savedMap.put(key, id);
        SQLQuery query = super.getSession().createSQLQuery(sql.toString());
        for (i = 0; i < fieldCount; ++i) {
            query.setParameter(i, valueList.get(i));
        }
        query.executeUpdate();
        for (i = 0; i < todoGetMethodList.size(); ++i) {
            Object value;
            Method method = (Method)todoGetMethodList.get(i);
            annoObj = method.getAnnotation(OneToMany.class);
            if (annoObj != null) {
                value = (List)method.invoke(pojo, zeroClass);
                for (int j = 0; j < value.size(); ++j) {
                    this.saveBySqlInner(value.get(j), savedMap);
                }
            }
            if ((annoObj = method.getAnnotation(PrimaryKeyJoinColumn.class)) == null || (value = method.invoke(pojo, zeroClass)) == null) continue;
            this.saveBySqlInner(value, savedMap);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected Query createQuery(String fnHql, Session session) {
        Query query = session.createQuery(fnHql);
        if (!hqlQueryCacheFlagPattern.matcher(fnHql).matches()) {
            query.setCacheable(this.isCacheable());
        } else {
            query.setCacheable(false);
            session.flush();
        }
        return query;
    }

    protected List fetch(Criteria criteria, int startIndex, int realPageSize) {
        this.wrapCriteria(criteria);
        return criteria.setFirstResult(startIndex).setMaxResults(realPageSize).list();
    }

    protected void wrapCriteria(Criteria criteria) {
        criteria.setCacheable(this.isCacheable());
    }

    static {
        ignoreFieldNameMapAtSaveBySql = new ConcurrentHashMap<String, String>(2);
        ignoreFieldNameMapAtSaveBySql.put("inserttimeforhis", "InsertTimeForHis");
        ignoreFieldNameMapAtSaveBySql.put("operatetimeforhis", "OperateTimeForHis");
        hqlQueryCacheFlagPattern = Pattern.compile("[\\d\\D]+?\\W((?i)(count|avg|sum|max|min))\\s*\\([\\d\\D]+?");
    }
}

