/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.dao;

import ins.framework.utils.FileUtils;
import ins.framework.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SameDirClassFactoryBean
extends ArrayList<String> {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog(SameDirClassFactoryBean.class);
    private Map<String, String> classMap = new HashMap<String, String>();

    public SameDirClassFactoryBean(List<String> classNames) {
        this.execute(classNames);
    }

    public SameDirClassFactoryBean(String className) {
        ArrayList<String> classNames = new ArrayList<String>();
        classNames.add(className);
        this.execute(classNames);
    }

    private void execute(List<String> classNames) {
        this.clear();
        try {
            for (String className : classNames) {
                if (super.contains(className)) continue;
                String pathName = FileUtils.getRealPathName(Class.forName(className).newInstance().getClass());
                if (pathName.startsWith("/")) {
                    pathName = pathName.substring("/".length());
                }
                if (pathName.startsWith("file:/")) {
                    pathName = pathName.substring("file:/".length());
                }
                if ((pathName = StringUtils.replace(pathName, "%20", " ")).indexOf(58) == -1) {
                    pathName = "/" + pathName;
                }
                String classPrefix = "";
                if (className.indexOf(46) > -1) {
                    classPrefix = className.substring(0, className.lastIndexOf(46)) + ".";
                }
                if (pathName.indexOf(".jar!") > -1) {
                    int pos = pathName.indexOf(".jar!");
                    pathName = pathName.substring(0, pos + 4);
                    try {
                        ZipEntry entry;
                        ZipInputStream zin = new ZipInputStream(new FileInputStream(pathName));
                        while ((entry = zin.getNextEntry()) != null) {
                            String entryName = entry.getName();
                            zin.closeEntry();
                            entryName = StringUtils.replace(entryName, '/', ".");
                            if (!(entryName = StringUtils.replace(entryName, '\\', ".")).startsWith(classPrefix) || !entryName.endsWith(".class") || (entryName = entryName.substring(classPrefix.length(), entryName.length() - ".class".length())).indexOf(46) != -1 || entryName.endsWith("Id")) continue;
                            this.addToList(classPrefix + entryName);
                        }
                        zin.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                    continue;
                }
                File dir = new File(pathName).getParentFile();
                logger.debug((Object)("path=[" + dir.getAbsolutePath() + "]"));
                String[] files = dir.list(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        if (name.endsWith("Id.class")) {
                            return false;
                        }
                        return name.endsWith(".class");
                    }
                });
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        this.addToList(classPrefix + files[i].substring(0, files[i].length() - ".class".length()));
                    }
                    continue;
                }
                logger.warn((Object)("Can't find anything in this package dir [" + dir + "]"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void addToList(String className) {
        if (this.classMap.containsKey(className)) {
            logger.info((Object)("Annotated class [" + className + "] has been found."));
        } else {
            this.classMap.put(className, "");
            this.add(className);
            logger.info((Object)("Find annotated class [" + className + "]"));
        }
    }
}

