/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.dao.support;

import ins.framework.dao.GenericDao;
import ins.framework.dao.support.AnnotationMethod;
import ins.framework.utils.BeanUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EntityUtils {
    private static final Log logger = LogFactory.getLog(EntityUtils.class);
    private static Map<Class, String> supportTypeMap = new HashMap<Class, String>();
    private GenericDao service;

    public EntityUtils(GenericDao service) {
        this.service = service;
    }

    private AnnotationMethod getAnnMethod(Class clazz, Object parent) {
        Method[] methods;
        Method idMethod = null;
        Method refMethod = null;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            Annotation[] annotations;
            String methodName = method.getName();
            if (!methodName.startsWith("get") && !methodName.startsWith("is") || (annotations = method.getAnnotations()) == null) continue;
            for (Annotation annotation : annotations) {
                if (annotation instanceof Id || annotation instanceof EmbeddedId) {
                    idMethod = method;
                    continue;
                }
                if (!(annotation instanceof JoinColumn) && !(annotation instanceof JoinColumns) || !parent.getClass().equals(method.getReturnType())) continue;
                refMethod = method;
            }
            if (idMethod == null || refMethod == null) continue;
            return new AnnotationMethod(idMethod, refMethod);
        }
        return new AnnotationMethod(idMethod, refMethod);
    }

    private boolean needHandleMethod(Method method) {
        Annotation[] annotations = method.getAnnotations();
        if (annotations == null) {
            return true;
        }
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Id) && !(annotation instanceof EmbeddedId) && !(annotation instanceof JoinColumn) && !(annotation instanceof JoinColumns)) continue;
            return false;
        }
        return true;
    }

    private void mergeList(List listTarget, List listSource, boolean isCopyNull, Object parent) throws Exception {
        Object key;
        Class<?> clazz = null;
        if (listSource.size() > 0) {
            clazz = listSource.get(0).getClass();
        } else if (listTarget.size() > 0) {
            clazz = listTarget.get(0).getClass();
        }
        if (clazz == null) {
            return;
        }
        AnnotationMethod annMethod = this.getAnnMethod(clazz, parent);
        Method idMethod = annMethod.getIdMethod();
        Method refMethod = annMethod.getRefMethod();
        HashMap mapSource = new HashMap();
        HashMap mapTarget = new HashMap();
        Object[] params = new Object[]{};
        String refSetMethod = "set" + refMethod.getName().substring(3);
        for (Object element : listSource) {
            key = idMethod.invoke(element, params);
            mapSource.put(key, element);
        }
        for (Object element : listTarget) {
            key = idMethod.invoke(element, params);
            mapTarget.put(key, element);
        }
        Iterator it = listTarget.iterator();
        while (it.hasNext()) {
            Object element;
            element = it.next();
            key = idMethod.invoke(element, params);
            if (!mapSource.containsKey(key)) {
                this.service.delete(element);
                it.remove();
                continue;
            }
            this.mergeObject(element, mapSource.get(key), isCopyNull);
        }
        Class[] setParamsClasses = new Class[]{parent.getClass()};
        Object[] setParams = new Object[]{parent};
        for (Object element : listSource) {
            Object key2 = idMethod.invoke(element, params);
            if (key2 != null && mapTarget.containsKey(key2)) continue;
            listTarget.add(element);
            BeanUtils.invoke(element, refSetMethod, setParamsClasses, setParams);
        }
    }

    private void mergeObject(Object target, Object source, boolean isCopyNull) throws Exception {
        if (target == null || source == null) {
            return;
        }
        List<Method> getterMethodList = BeanUtils.getGetter(source.getClass());
        List<Method> setterMethodList = BeanUtils.getSetter(target.getClass());
        HashMap<String, Method> map = new HashMap<String, Method>();
        for (Method method : getterMethodList) {
            map.put(method.getName(), method);
        }
        for (Method method : setterMethodList) {
            String fieldName = method.getName().substring(3);
            Method getterMethod = (Method)map.get("get" + fieldName);
            if (getterMethod == null) {
                getterMethod = (Method)map.get("is" + fieldName);
            }
            if (getterMethod == null || !this.needHandleMethod(getterMethod)) continue;
            if (!supportTypeMap.containsKey(getterMethod.getReturnType())) {
                logger.warn((Object)("not supprot type: " + getterMethod.getReturnType()));
                continue;
            }
            Object value = getterMethod.invoke(source, new Object[0]);
            if (getterMethod.getReturnType() == List.class) {
                Object target_value = getterMethod.invoke(target, new Object[0]);
                this.mergeList((List)target_value, (List)value, isCopyNull, target);
                continue;
            }
            if (isCopyNull) {
                method.invoke(target, value);
                continue;
            }
            if (value == null) continue;
            method.invoke(target, value);
        }
    }

    public void mergeComplexObjectToTargetFromSource(Object target, Object source, boolean isCopyNull) {
        try {
            this.mergeObject(target, source, isCopyNull);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        supportTypeMap.put(Integer.TYPE, "");
        supportTypeMap.put(Long.TYPE, "");
        supportTypeMap.put(Double.TYPE, "");
        supportTypeMap.put(Boolean.TYPE, "");
        supportTypeMap.put(Integer.class, "");
        supportTypeMap.put(Long.class, "");
        supportTypeMap.put(Double.class, "");
        supportTypeMap.put(BigDecimal.class, "");
        supportTypeMap.put(String.class, "");
        supportTypeMap.put(Date.class, "");
        supportTypeMap.put(Boolean.class, "");
        supportTypeMap.put(byte[].class, "");
        supportTypeMap.put(List.class, "");
    }
}

