/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.dao.support;

import ins.framework.utils.Proxys;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MonitorDataSourceFactory
implements FactoryBean {
    static Log log = LogFactory.getLog(MonitorDataSourceFactory.class);
    private DataSource targetDataSource;
    private DataSource proxyDataSource;
    private int autoLogTimeoutMilliseconds = -1;
    private int autoKillTimeoutSeconds = -1;
    private boolean trace;

    public DataSource getTargetDataSource() {
        return this.targetDataSource;
    }

    public void setTargetDataSource(DataSource targetDataSource) {
        this.targetDataSource = targetDataSource;
    }

    public int getAutoLogTimeoutMilliseconds() {
        return this.autoLogTimeoutMilliseconds;
    }

    public void setAutoLogTimeoutMilliseconds(int autoLogTimeoutMilliseconds) {
        this.autoLogTimeoutMilliseconds = autoLogTimeoutMilliseconds;
    }

    public int getAutoKillTimeoutSeconds() {
        return this.autoKillTimeoutSeconds;
    }

    public void setAutoKillTimeoutSeconds(int autoKillTimeoutSeconds) {
        this.autoKillTimeoutSeconds = autoKillTimeoutSeconds;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource getObject() throws Exception {
        if (this.proxyDataSource == null) {
            MonitorDataSourceFactory monitorDataSourceFactory = this;
            synchronized (monitorDataSourceFactory) {
                this.proxyDataSource = Proxys.newProxyInstance(DataSource.class, new InvocationHandler(){

                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if (Connection.class.isAssignableFrom(method.getReturnType())) {
                            Connection originalConnection = (Connection)method.invoke((Object)MonitorDataSourceFactory.this.targetDataSource, args);
                            return MonitorDataSourceFactory.this.proxyConnection(originalConnection);
                        }
                        return method.invoke((Object)MonitorDataSourceFactory.this.targetDataSource, args);
                    }
                });
            }
        }
        return this.proxyDataSource;
    }

    protected Connection proxyConnection(final Connection originalConnection) {
        Connection proxyConnection = Proxys.newProxyInstance(Connection.class, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (Statement.class.isAssignableFrom(method.getReturnType())) {
                    Class<?> returnType;
                    Statement originalStatement = (Statement)method.invoke((Object)originalConnection, args);
                    if (MonitorDataSourceFactory.this.autoKillTimeoutSeconds > 0) {
                        originalStatement.setQueryTimeout(MonitorDataSourceFactory.this.autoKillTimeoutSeconds);
                    }
                    if (PreparedStatement.class.isAssignableFrom(returnType = method.getReturnType()) && method.getParameterTypes().length >= 1 && method.getParameterTypes()[0].equals(String.class)) {
                        String sql = (String)args[0];
                        return MonitorDataSourceFactory.this.proxyStatement(returnType, originalStatement, sql);
                    }
                    return MonitorDataSourceFactory.this.proxyStatement(returnType, originalStatement);
                }
                return method.invoke((Object)originalConnection, args);
            }
        });
        return proxyConnection;
    }

    protected Object proxyStatement(Class<? extends Statement> returnType, Statement originalStatement) {
        return this.proxyStatement(returnType, originalStatement, null);
    }

    protected Statement proxyStatement(Class<? extends Statement> statementType, final Statement originalStatement, String sql) {
        final SqlInfo sqlInfo = new SqlInfo();
        if (sql != null) {
            sqlInfo.sql = sql;
        }
        Statement proxyStatement = Proxys.newProxyInstance(statementType, new InvocationHandler(){
            SqlInfo mainSqlInfo;
            List<SqlInfo> sqlInfoBatchList;
            {
                this.mainSqlInfo = sqlInfo;
                this.sqlInfoBatchList = new ArrayList<SqlInfo>();
            }

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String sql;
                if (method.getReturnType().equals(Void.TYPE) && method.getName().startsWith("set") && method.getParameterTypes().length > 1 && method.getParameterTypes()[0].equals(Integer.TYPE)) {
                    if (args.length == 2) {
                        this.mainSqlInfo.parameterList.add(args[args.length - 1]);
                    } else {
                        ArrayList<Object> parameter = new ArrayList<Object>();
                        for (int i = 1; i < args.length; ++i) {
                            parameter.add(args[i]);
                        }
                        this.mainSqlInfo.parameterList.add(parameter);
                    }
                }
                if (method.getName().startsWith("addBatch")) {
                    if (method.getParameterTypes().length >= 1) {
                        if (method.getParameterTypes()[0].equals(String.class)) {
                            sql = (String)args[0];
                            SqlInfo sqlInfo2 = new SqlInfo();
                            sqlInfo2.sql = sql;
                            this.sqlInfoBatchList.add(sqlInfo2);
                        }
                    } else {
                        this.sqlInfoBatchList.add(this.mainSqlInfo);
                        this.mainSqlInfo = new SqlInfo();
                        this.mainSqlInfo.sql = this.sqlInfoBatchList.get((int)(this.sqlInfoBatchList.size() - 1)).sql;
                    }
                }
                if (method.getName().startsWith("execute")) {
                    if (method.getParameterTypes().length >= 1 && method.getParameterTypes()[0].equals(String.class)) {
                        this.mainSqlInfo.sql = sql = (String)args[0];
                    }
                    if (MonitorDataSourceFactory.this.autoLogTimeoutMilliseconds >= 0) {
                        long start = System.currentTimeMillis();
                        Object returnValue = method.invoke((Object)originalStatement, args);
                        long end = System.currentTimeMillis();
                        long time = end - start;
                        if (time >= (long)MonitorDataSourceFactory.this.autoLogTimeoutMilliseconds && log.isWarnEnabled()) {
                            if (MonitorDataSourceFactory.this.trace) {
                                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                PrintWriter pw = new PrintWriter(baos);
                                new Throwable().printStackTrace(pw);
                                pw.close();
                                baos.close();
                                String info = String.format("sql(%dms>=%dms):%s\r\ntrace:%s", time, MonitorDataSourceFactory.this.autoLogTimeoutMilliseconds, this.sqlInfoBatchList.isEmpty() ? this.mainSqlInfo : this.sqlInfoBatchList, baos.toString());
                                log.warn((Object)info);
                            } else {
                                String info = String.format("sql(%dms>=%dms):%s", time, MonitorDataSourceFactory.this.autoLogTimeoutMilliseconds, this.sqlInfoBatchList.isEmpty() ? this.mainSqlInfo : this.sqlInfoBatchList);
                                log.warn((Object)info);
                            }
                        }
                        return returnValue;
                    }
                }
                return method.invoke((Object)originalStatement, args);
            }
        });
        return proxyStatement;
    }

    public Class<?> getObjectType() {
        return DataSource.class;
    }

    public boolean isSingleton() {
        return true;
    }

    class SqlInfo {
        String sql;
        List parameterList = new ArrayList();

        SqlInfo() {
        }

        public String toString() {
            return "{sql:" + this.sql + ", parameters:" + this.parameterList + "}";
        }
    }
}

