/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.dao.support;

import ins.framework.common.QueryRule;
import ins.framework.utils.StringUtils;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class QueryRuleUtils {
    public static void createCriteriaWithQueryRule(Criteria criteria, QueryRule queryRule) {
        block18: for (QueryRule.Rule rule : queryRule.getRuleList()) {
            switch (rule.getType()) {
                case 3: {
                    QueryRuleUtils.processBetween(criteria, rule);
                    continue block18;
                }
                case 4: {
                    QueryRuleUtils.processEqual(criteria, rule);
                    continue block18;
                }
                case 1: {
                    QueryRuleUtils.processLike(criteria, rule);
                    continue block18;
                }
                case 5: {
                    QueryRuleUtils.processNotEqual(criteria, rule);
                    continue block18;
                }
                case 6: {
                    QueryRuleUtils.processGreaterThen(criteria, rule);
                    continue block18;
                }
                case 7: {
                    QueryRuleUtils.processGreaterEqual(criteria, rule);
                    continue block18;
                }
                case 8: {
                    QueryRuleUtils.processLessThen(criteria, rule);
                    continue block18;
                }
                case 9: {
                    QueryRuleUtils.processLessEqual(criteria, rule);
                    continue block18;
                }
                case 10: {
                    QueryRuleUtils.processSQL(criteria, rule);
                    continue block18;
                }
                case 2: {
                    QueryRuleUtils.processIN(criteria, rule);
                    continue block18;
                }
                case 11: {
                    QueryRuleUtils.processIsNull(criteria, rule);
                    continue block18;
                }
                case 12: {
                    QueryRuleUtils.processIsNotNull(criteria, rule);
                    continue block18;
                }
                case 13: {
                    QueryRuleUtils.processIsEmpty(criteria, rule);
                    continue block18;
                }
                case 14: {
                    QueryRuleUtils.processIsNotEmpty(criteria, rule);
                    continue block18;
                }
                case 101: {
                    continue block18;
                }
                case 102: {
                    continue block18;
                }
            }
            throw new IllegalArgumentException("type " + rule.getType() + " not supported.");
        }
        for (QueryRule subQueryRule : queryRule.getQueryRuleList()) {
            Criteria subCriteria = criteria.createCriteria(subQueryRule.getPropertyName());
            QueryRuleUtils.createCriteriaWithQueryRule(subCriteria, subQueryRule);
        }
    }

    protected static void processLike(Criteria criteria, QueryRule.Rule rule) {
        String value;
        if (ArrayUtils.isEmpty((Object[])rule.getValues())) {
            return;
        }
        Object obj = rule.getValues()[0];
        if (obj != null && StringUtils.isNotEmpty((String)(value = obj.toString()))) {
            value = value.replace('*', '%');
            obj = value;
        }
        criteria.add((Criterion)Restrictions.like((String)rule.getPropertyName(), (Object)obj));
    }

    protected static void processBetween(Criteria criteria, QueryRule.Rule rule) {
        if (ArrayUtils.isEmpty((Object[])rule.getValues()) || rule.getValues().length < 2) {
            return;
        }
        criteria.add(Restrictions.between((String)rule.getPropertyName(), (Object)rule.getValues()[0], (Object)rule.getValues()[1]));
    }

    protected static void processEqual(Criteria criteria, QueryRule.Rule rule) {
        if (ArrayUtils.isEmpty((Object[])rule.getValues())) {
            return;
        }
        criteria.add((Criterion)Restrictions.eq((String)rule.getPropertyName(), (Object)rule.getValues()[0]));
    }

    protected static void processNotEqual(Criteria criteria, QueryRule.Rule rule) {
        if (ArrayUtils.isEmpty((Object[])rule.getValues())) {
            return;
        }
        criteria.add((Criterion)Restrictions.ne((String)rule.getPropertyName(), (Object)rule.getValues()[0]));
    }

    protected static void processGreaterThen(Criteria criteria, QueryRule.Rule rule) {
        if (ArrayUtils.isEmpty((Object[])rule.getValues())) {
            return;
        }
        criteria.add((Criterion)Restrictions.gt((String)rule.getPropertyName(), (Object)rule.getValues()[0]));
    }

    protected static void processGreaterEqual(Criteria criteria, QueryRule.Rule rule) {
        if (ArrayUtils.isEmpty((Object[])rule.getValues())) {
            return;
        }
        criteria.add((Criterion)Restrictions.ge((String)rule.getPropertyName(), (Object)rule.getValues()[0]));
    }

    protected static void processLessThen(Criteria criteria, QueryRule.Rule rule) {
        if (ArrayUtils.isEmpty((Object[])rule.getValues())) {
            return;
        }
        criteria.add((Criterion)Restrictions.lt((String)rule.getPropertyName(), (Object)rule.getValues()[0]));
    }

    protected static void processLessEqual(Criteria criteria, QueryRule.Rule rule) {
        if (ArrayUtils.isEmpty((Object[])rule.getValues())) {
            return;
        }
        criteria.add((Criterion)Restrictions.le((String)rule.getPropertyName(), (Object)rule.getValues()[0]));
    }

    protected static void processSQL(Criteria criteria, QueryRule.Rule rule) {
        criteria.add(Restrictions.sqlRestriction((String)rule.getPropertyName()));
    }

    protected static void processIsNull(Criteria criteria, QueryRule.Rule rule) {
        criteria.add(Restrictions.isNull((String)rule.getPropertyName()));
    }

    protected static void processIsNotNull(Criteria criteria, QueryRule.Rule rule) {
        criteria.add(Restrictions.isNotNull((String)rule.getPropertyName()));
    }

    protected static void processIsNotEmpty(Criteria criteria, QueryRule.Rule rule) {
        criteria.add(Restrictions.isNotEmpty((String)rule.getPropertyName()));
    }

    protected static void processIsEmpty(Criteria criteria, QueryRule.Rule rule) {
        criteria.add(Restrictions.isEmpty((String)rule.getPropertyName()));
    }

    protected static void processIN(Criteria criteria, QueryRule.Rule rule) {
        if (ArrayUtils.isEmpty((Object[])rule.getValues())) {
            return;
        }
        if (rule.getValues().length == 1 && rule.getValues()[0] != null && rule.getValues()[0] instanceof List) {
            List list = (List)rule.getValues()[0];
            if (list != null && !list.isEmpty()) {
                criteria.add(Restrictions.in((String)rule.getPropertyName(), (Collection)list));
            }
        } else {
            criteria.add(Restrictions.in((String)rule.getPropertyName(), (Object[])rule.getValues()));
        }
    }
}

