/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.mail;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import ins.framework.mail.MailService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.springframework.util.Assert;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

public class JavaMailServiceImpl
implements MailService,
InitializingBean {
    private static final Log logger = LogFactory.getLog(JavaMailServiceImpl.class);
    protected JavaMailSender mailSender;
    private FreeMarkerConfigurer mailTemplateEngine = null;

    public void setMailTemplateEngine(FreeMarkerConfigurer mailTemplateEngine) {
        this.mailTemplateEngine = mailTemplateEngine;
    }

    public void setMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }

    public void send(SimpleMailMessage msg) {
        try {
            this.mailSender.send(msg);
        }
        catch (MailException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void send(String from, String to, String subject, String text) {
        SimpleMailMessage msg = new SimpleMailMessage();
        msg.setFrom(from);
        msg.setTo(to);
        msg.setSubject(subject);
        msg.setText(text);
        this.send(msg);
    }

    public void send(SimpleMailMessage msg, String templateName, Map model) {
        String content = this.generateEmailContent(templateName, model);
        try {
            MimeMessage mimeMsg = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(mimeMsg, true, "utf-8");
            helper.setTo(msg.getTo());
            helper.setSubject(msg.getSubject());
            helper.setFrom(msg.getFrom());
            helper.setText(content, true);
        }
        catch (MessagingException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        msg.setText(content);
        this.mailSender.send(msg);
    }

    public String generateEmailContent(String templateName, Map map) {
        try {
            Template t = this.mailTemplateEngine.getConfiguration().getTemplate(templateName);
            return FreeMarkerTemplateUtils.processTemplateIntoString((Template)t, (Object)map);
        }
        catch (TemplateException e) {
            logger.error((Object)"Error while processing FreeMarker template ", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"Error while open template file ", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"Error while generate Email Content ", (Throwable)e);
        }
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.mailSender, (String)"\u672a\u6ce8\u5165MailSender");
    }

    public MimeMessageHelper createMimeMessageHelper() {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = null;
        try {
            helper = new MimeMessageHelper(message, true, "GBK");
        }
        catch (MessagingException me) {
            throw new IllegalStateException(me);
        }
        return helper;
    }

    public void send(MimeMessage mimeMessage) {
        this.mailSender.send(mimeMessage);
    }
}

